/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtkhtml;

import org.gnu.gtk.Layout;

public class HTMLView extends Layout {
	
	public HTMLView() {
		super(html_view_new());
	}
	
	public void setDocument(HTMLDocument document) {
		if (null == document) 
			html_view_set_document(getHandle(), 0);
		else
			html_view_set_document(getHandle(), document.getHandle());
	}
	
	public void jumpToAnchor(String anchor) {
		html_view_jump_to_anchor(getHandle(), anchor);
	}
	
	public double getMagnification() {
		return html_view_get_magnification(getHandle());
	}
	
	public void setMagnification(double magnification) {
		html_view_set_magnification(getHandle(), magnification);
	}
	
	public void zoomIn() {
		html_view_zoom_in(getHandle());
	}
	
	public void zoomOut() {
		html_view_zoom_out(getHandle());
	}
	
	public void zoomReset() {
		html_view_zoom_reset(getHandle());
	}

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int html_view_get_type();
	native static final protected int html_view_new();
	native static final protected void html_view_set_document(int view, int document);
	native static final protected void html_view_jump_to_anchor(int view, String anchor);
	native static final protected double html_view_get_magnification(int view);
	native static final protected void html_view_set_magnification(int view, double magnification);
	native static final protected void html_view_zoom_in(int view);
	native static final protected void html_view_zoom_out(int view);
	native static final protected void html_view_zoom_reset(int view);
	native static final protected int html_view_find_layout_box(int view, int node, boolean findParent);
	native static final protected void html_view_scroll_to_node(int view, int node, int scrollType);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
	static {
		System.loadLibrary("gtkhtmljava2.6");
	}
}
