/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Boxed;


/**
 * A FontMetrics structure holds the overall metric information for a font
 * (possibly restricted to a script).
 */
public class FontMetrics extends Boxed 
{
	protected FontMetrics(int handle){
		this.handle = handle;
	}


		
	/****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int pango_font_metrics_get_type ();
    native static final protected int pango_font_metrics_ref (int metrics);
    native static final protected void pango_font_metrics_unref (int metrics);
    native static final protected int pango_font_metrics_get_ascent (int metrics);
    native static final protected int pango_font_metrics_get_descent (int metrics);
    native static final protected int pango_font_metrics_get_approximate_char_width (int metrics);
    native static final protected int pango_font_metrics_get_approximate_digit_width (int metrics);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

