/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtkhtml.event;

import org.gnu.gtk.event.GtkEvent;
import org.gnu.gtk.event.GtkEventType;

/**
 * An event represeting action by a {@link org.gnu.gtkhtml.HTMLDocument} widget.
 */
public class HTMLDocumentEvent extends GtkEvent {
	
	private String url;
	private String method;
	private String encoding;
	
	/**
	 * Type of a ButtonEvent
	 */
	public static class Type extends GtkEventType {
		private Type(int id, String name) {
			super(id, name);
		}

		public static final Type LINK_CLICKED = new Type(1, "LINK_CLICKED");
		public static final Type SUBMIT = new Type(1, "SUBMIT");
	}

	/**
	 * Creates a new Button HTMLDocumentEvent. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public HTMLDocumentEvent(Object source, HTMLDocumentEvent.Type type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(HTMLDocumentEvent.Type aType) {
		return (type.getID() == aType.getID());
	}

	public String getEncoding() {
		return encoding;
	}
	
	public void setEncoding(String e) {
		encoding = e;
	}
	
	public String getMethod() {
		return method;
	}
	
	public void setMethod(String m) {
		method = m;
	}

	public String getURL() {
		return url;
	}

	public void setURL(String u) {
		url = u;
	}
}
