/*
Jaxe - Editeur XML en Java

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package jaxe;

import org.apache.log4j.Logger;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.text.html.HTMLDocument;

import org.w3c.dom.Element;


/**
 * Fentre d'affichage du rendu HTML aprs transformation XSL
 */
public class HTMLFrame extends JFrame {
    /**
     * Logger for this class
     */
    private static final Logger LOG = Logger.getLogger(HTMLFrame.class);

    JaxeDocument doc;
    HTMLDocument htmldoc;
    JTextPane textPane;
    JButton boutonNav;

    public HTMLFrame(final JaxeDocument doc) {
        newdoc(doc);
    }
    
    public void newdoc(final JaxeDocument doc) {
        this.doc = doc;
        if (doc.cfg == null)
            return; // ajouter un message d'erreur ?
        htmldoc = new HTMLDocument();
        final Rectangle fr = doc.jframe.getBounds();
        setLocation(fr.x + fr.width/2, fr.y + fr.height/2);
        setSize(new Dimension(620, 460));
        affichage();
        // on ne recalcule pas le HTML  l'ouverture si le fichier HTML existe dj
        if (doc.fsave != null) {
            final File htmlFile = fichierHTML(doc.fsave);
            if (htmlFile.exists()) {
                try {
                    final URL url = htmlFile.toURI().toURL();
                    textPane.setPage(url);
                    setTitle(htmlFile.getName());
                } catch (final Exception ex) {
                    afficherErreur(ex);
                }
                setVisible(true);
            } else
                miseAJour();
        } else {
            JOptionPane.showMessageDialog(doc.jframe,
                JaxeResourceBundle.getRB().getString("html.SauverAvant"),
                JaxeResourceBundle.getRB().getString("erreur.Erreur"),
                JOptionPane.ERROR_MESSAGE);
        }
    }
    
    protected void affichage() {
        textPane = new JTextPane(htmldoc);
        textPane.setEditable(false);
        final JScrollPane paneScrollPane = new JScrollPane(textPane);
        paneScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        paneScrollPane.setPreferredSize(new Dimension(600, 400));

        final JPanel boutonsP = new JPanel();
        boutonsP.setLayout(new FlowLayout());
        final JButton boutonMAJ = new JButton(JaxeResourceBundle.getRB().getString("html.MiseAJour"));
        boutonMAJ.addActionListener(new MAJListener());
        boutonsP.add(boutonMAJ);
        
        boutonNav = new JButton();
        boutonNav.setAction(new AbstractAction(JaxeResourceBundle.getRB().getString("html.Navigateur")) {
            public void actionPerformed(final ActionEvent e) {
                lancerNavigateur();
            }
        });
        boutonsP.add(boutonNav);
        
        final JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add(paneScrollPane, BorderLayout.CENTER);
        contentPane.add(boutonsP, BorderLayout.NORTH);
        setContentPane(contentPane);
    }
    
    /**
     * nom du fichier HTML pour un fichier XML donn
     */
    public static File fichierHTML(final File fichierXML) {
        String nomFsave = fichierXML.getName();
        final int ie = nomFsave.lastIndexOf('.');
        if (ie != -1) {
            if (!"html".equals(nomFsave.substring(ie+1)))
                nomFsave = nomFsave.substring(0, ie);
//            else
                // pour terminer en .html.html
        }
        return(new File(fichierXML.getParent() + File.separatorChar + nomFsave + ".html"));
    }
    
    public void miseAJour() {
        if (doc.fsave == null) {
            JOptionPane.showMessageDialog(doc.jframe,
                JaxeResourceBundle.getRB().getString("html.SauverAvant"),
                JaxeResourceBundle.getRB().getString("erreur.Erreur"),
                JOptionPane.ERROR_MESSAGE);
            return;
        }
        final ArrayList<Element> listeExportsHTML = doc.cfg.listeExports("HTML");
        if (listeExportsHTML == null || listeExportsHTML.size() == 0)
            return;
        final Export exp = new Export(doc, listeExportsHTML.get(0));
        exp.transformation(fichierHTML(doc.fsave), this); // appelle afficherHTML  la fin
    }
    
    public void afficherHTML(final File outFile) {
        try {
            affichage(); // pour refaire textPane, sinon update marche pas
            if (outFile != null) {
                final URL url = outFile.toURI().toURL();
                textPane.setPage(url);
                setTitle(outFile.getName());
            }
        } catch (final Exception ex) {
            afficherErreur(ex);
        }
        
        setVisible(true);
    }
    
    protected void afficherErreur(final Exception ex) {
        JOptionPane.showMessageDialog(doc.jframe,
            ex.getClass().getName() + ": " + ex.getMessage(),
            JaxeResourceBundle.getRB().getString("erreur.Erreur"),
            JOptionPane.ERROR_MESSAGE);
    }
    
    class MAJListener implements ActionListener {
        public void actionPerformed(final ActionEvent e) {
            miseAJour();
        }
    }
    
    public void lancerNavigateur() {
        Properties prefs = Preferences.getPref();
        String cheminNav = prefs.getProperty("navigateur");
        if (cheminNav == null) {
            defNavigateur();
            prefs = Preferences.getPref();
            cheminNav = prefs.getProperty("navigateur");
            if (cheminNav == null)
                return;
        }
        String[] acmd;
        final File htmlFile = fichierHTML(doc.fsave);
        if (System.getProperty("os.name").startsWith("Mac")) {
            acmd = new String[4];
            acmd[0] = "/usr/bin/open";
            acmd[1] = "-a";
            acmd[2] = cheminNav;
            acmd[3] = htmlFile.getAbsolutePath();
        } else {
            acmd = new String[2];
            acmd[0] = cheminNav;
            acmd[1] = htmlFile.getAbsolutePath();
        }
        try {
            Runtime.getRuntime().exec(acmd);
        } catch (final IOException ex) {
            LOG.error("lancerNavigateur()", ex);
        }
    }
    
    public void defNavigateur() {
        final FileDialog fdlg = new FileDialog(this,
            JaxeResourceBundle.getRB().getString("html.DefNavigateur"), FileDialog.LOAD);
        fdlg.setVisible(true);
        String chemin = null;
        String dir = fdlg.getDirectory();
        if (dir != null && dir.endsWith(File.separator))
            dir = dir.substring(0, dir.length()-1);
        final String nom = fdlg.getFile();
        if (dir == null)
            chemin = nom;
        else if (nom != null)
            chemin = dir + File.separator + nom;
        if (chemin != null) {
            final Properties prefs = Preferences.getPref();
            prefs.setProperty("navigateur", chemin);
            Preferences.enregistrerPref(prefs);
        }
    }
    
}
