/*
Jaxe - Editeur XML en Java

Copyright (C) 2003 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package jaxe;

import org.apache.log4j.Logger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Properties;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Prfrences:
 * 
 *     fenetreArbre
 *     fenetreInsertion
 *     fenetreAttributs
 *     navigateur
 *     consIndent
 *     iconeValide
 *     dictionnaire
 */
public class Preferences extends JDialog implements ActionListener {
    /**
     * Logger for this class
     */
    private static final Logger LOG = Logger.getLogger(Preferences.class);

    private static final File fpref = trouverFichier();
    private static Properties prefs = getPreferencesParDefaut();
    
    private final JCheckBox caseArbre;
    private final JCheckBox caseInsertion;
    private final JCheckBox caseAttributs;
    private final JLabel labelNav;
    private String prefNav;
    private final JCheckBox caseIndent;
    private final JLabel labelDico;
    private String prefDico;
    private final JCheckBox caseIconeValide;
    
    public static File trouverFichier() {
        try {
            final String userHome = System.getProperty("user.home");
            final String osName = System.getProperty("os.name");
            final File fichierPref;
            if (osName.indexOf("Windows") != -1)
                fichierPref = new File(userHome, "jaxepreferences");
            else if (osName.startsWith("Mac"))
                fichierPref = new File(userHome, "Library/Preferences/Jaxe Preferences");
            else
                fichierPref = new File(userHome, ".jaxe");
            return(fichierPref);
        } catch (final AccessControlException ex) {
            LOG.error("Jaxe Preferences.trouverFichier", ex);
            return(null);
        }
    }
    
    public static Properties getPreferencesParDefaut() {
        final Properties defauts = new Properties();
        defauts.setProperty("fenetreArbre", "true");
        defauts.setProperty("fenetreInsertion", "true");
        defauts.setProperty("fenetreAttributs", "true");
        //defauts.setProperty("navigateur", null);
        if (System.getProperty("os.name").startsWith("Mac"))
            defauts.setProperty("navigateur", "/Applications/Safari.app");
        defauts.setProperty("consIndent", "false");
        //defauts.setProperty("dictionnaire", null);
        defauts.setProperty("iconeValide", "true");
        return(defauts);
    }
    
    public static Properties chargerPref() {
        prefs = getPreferencesParDefaut();
        try {
            if (fpref != null && fpref.exists()) {
                final FileInputStream fis = new FileInputStream(fpref);
                prefs.load(fis);
                fis.close();
            }
        } catch (final IOException ex) {
            LOG.error("chargerPref()", ex);
            return(null);
        }
        return(prefs);
    }
    
    public static Properties getPref() {
        return(prefs);
    }
    
    public static void enregistrerPref(final Properties prefs1) {
        if (prefs1 == null)
            return;
        prefs = prefs1;
        try {
            final FileOutputStream fos = new FileOutputStream(fpref);
            prefs.store(fos, "Prfrences de Jaxe");
            fos.close();
        } catch (final IOException ex) {
            LOG.error("enregistrerPref(Properties)", ex);
        }
    }
    
    public Preferences(final JFrame jframe) {
        super(jframe, JaxeResourceBundle.getRB().getString("pref.Preferences"), true);
        this.getContentPane().setLayout(new BorderLayout());
        
        final Properties prefs = getPref();
        final String prefArbre = prefs.getProperty("fenetreArbre");
        final String prefInsertion = prefs.getProperty("fenetreInsertion");
        final String prefAttributs = prefs.getProperty("fenetreAttributs");
        prefNav = prefs.getProperty("navigateur");
        final String prefIndent = prefs.getProperty("consIndent");
        prefDico = prefs.getProperty("dictionnaire");
        final String prefIconeValide = prefs.getProperty("iconeValide");
        
        final JPanel prefPanes = new JPanel();
        prefPanes.setLayout(new BoxLayout(prefPanes, BoxLayout.Y_AXIS));
        
        final JPanel fenPane = new JPanel();
        fenPane.setLayout(new BoxLayout(fenPane, BoxLayout.Y_AXIS));
        fenPane.setBorder(BorderFactory.createTitledBorder(
            JaxeResourceBundle.getRB().getString("pref.Fenetres")));
        caseArbre = new JCheckBox(
            JaxeResourceBundle.getRB().getString("pref.Arbre"));
        caseArbre.setSelected(Boolean.parseBoolean(prefArbre));
        fenPane.add(caseArbre);
        caseInsertion = new JCheckBox(
            JaxeResourceBundle.getRB().getString("pref.Insertion"));
        caseInsertion.setSelected(Boolean.parseBoolean(prefInsertion));
        fenPane.add(caseInsertion);
        caseAttributs = new JCheckBox(
            JaxeResourceBundle.getRB().getString("pref.Attributs"));
        caseAttributs.setSelected(Boolean.parseBoolean(prefAttributs));
        fenPane.add(caseAttributs);
        prefPanes.add(fenPane);
        fenPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        fenPane.setMaximumSize(new Dimension(Short.MAX_VALUE,Short.MAX_VALUE));
        
        final JPanel navPane = new JPanel(new FlowLayout());
        navPane.setBorder(BorderFactory.createTitledBorder(
            JaxeResourceBundle.getRB().getString("pref.Navigateur")));
        String nomNav = null;
        if (prefNav != null)
            nomNav = (new File(prefNav)).getName();
        labelNav = new JLabel(nomNav);
        navPane.add(labelNav);
        final JButton defNav = new JButton(
            JaxeResourceBundle.getRB().getString("pref.Definir"));
        defNav.addActionListener(this);
        defNav.setActionCommand("defNav");
        navPane.add(defNav);
        prefPanes.add(navPane);
        navPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        
        final JPanel enrPane = new JPanel(new FlowLayout());
        enrPane.setLayout(new BoxLayout(enrPane, BoxLayout.Y_AXIS));
        enrPane.setBorder(BorderFactory.createTitledBorder(
            JaxeResourceBundle.getRB().getString("pref.Affichage")));
        caseIndent = new JCheckBox(
            JaxeResourceBundle.getRB().getString("pref.consIndent"));
        caseIndent.setSelected(Boolean.parseBoolean(prefIndent));
        enrPane.add(caseIndent);
        caseIconeValide = new JCheckBox(
            JaxeResourceBundle.getRB().getString("pref.iconeValide"));
        caseIconeValide.setSelected(Boolean.parseBoolean(prefIconeValide));
        enrPane.add(caseIconeValide);
        prefPanes.add(enrPane);
        enrPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        
        final JPanel dicoPane = new JPanel(new FlowLayout());
        dicoPane.setBorder(BorderFactory.createTitledBorder(
            JaxeResourceBundle.getRB().getString("pref.Dictionnaire")));
        String nomDico = null;
        if (prefDico != null) {
            nomDico = (new File(prefDico)).getName();
            final int pp = nomDico.lastIndexOf('.');
            if (pp != -1)
                nomDico = nomDico.substring(0, pp);
        }
        labelDico = new JLabel(nomDico);
        dicoPane.add(labelDico);
        final JButton defDico = new JButton(
            JaxeResourceBundle.getRB().getString("pref.Definir"));
        defDico.addActionListener(this);
        defDico.setActionCommand("defDico");
        dicoPane.add(defDico);
        prefPanes.add(dicoPane);
        dicoPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        
        this.getContentPane().add(prefPanes, BorderLayout.CENTER);
        
        final JPanel bPane = new JPanel(new FlowLayout(FlowLayout.CENTER, 15, 15));
        final JButton boutonAnnuler = new JButton(
            JaxeResourceBundle.getRB().getString("pref.Annuler"));
        boutonAnnuler.addActionListener(this);
        boutonAnnuler.setActionCommand("Annuler");
        bPane.add(boutonAnnuler);
        final JButton boutonOK = new JButton(
            JaxeResourceBundle.getRB().getString("pref.Enregistrer"));
        boutonOK.addActionListener(this);
        boutonOK.setActionCommand("Enregistrer");
        bPane.add(boutonOK);
        getRootPane().setDefaultButton(boutonOK);
        this.getContentPane().add(bPane, BorderLayout.SOUTH);
        this.pack();
        if (jframe != null) {
            final Rectangle r = jframe.getBounds();
            setLocation(r.x + r.width/4, r.y + r.height/4);
        } else {
            final Dimension dim = getSize();
            final Dimension ecran = getToolkit().getScreenSize();
            setLocation((ecran.width - dim.width)/2, (ecran.height - dim.height)/2);
        }
    }
    
    public void actionPerformed(final ActionEvent e) {
        final String cmd = e.getActionCommand();
        
        if ("Enregistrer".equals(cmd)) {
            final Properties prefs = getPref();
            
            prefs.setProperty("fenetreArbre", Boolean.toString(caseArbre.isSelected()));
            
            prefs.setProperty("fenetreInsertion", Boolean.toString(caseInsertion.isSelected()));
            
            prefs.setProperty("fenetreAttributs", Boolean.toString(caseAttributs.isSelected()));
             
            if (prefNav != null) {
                prefs.setProperty("navigateur", prefNav);
            } else {
                prefs.setProperty("navigateur", "");
            }
            
            if (prefDico != null) {
                prefs.setProperty("dictionnaire", prefDico);
            } else {
                prefs.setProperty("dictionnaire", "");
            }
            
            prefs.setProperty("consIndent", Boolean.toString(caseIndent.isSelected()));
            final String prefIconeValide = prefs.getProperty("iconeValide");
            prefs.setProperty("iconeValide", Boolean.toString(caseIconeValide.isSelected()));
            
            Preferences.enregistrerPref(prefs);
            
            if (Boolean.parseBoolean(prefIconeValide) != caseIconeValide.isSelected())
                for (final JaxeFrame jf : Jaxe.allFrames) {
                    if (jf.getTextPane() != null)
                        jf.getTextPane().setIconeValide(caseIconeValide.isSelected());
                }
            
        } else if ("defNav".equals(cmd)) {
            defNavigateur();
        } else if ("defDico".equals(cmd)) {
            defDictionnaire();
        }
        if ("Enregistrer".equals(cmd) || "Annuler".equals(cmd))
            setVisible(false);
    }
    
    public void defNavigateur() {
        final FileDialog fdlg = new FileDialog((Frame)getOwner(),
            JaxeResourceBundle.getRB().getString("pref.DefNavigateur"), FileDialog.LOAD);
        fdlg.setVisible(true);
        String chemin = null;
        String dir = fdlg.getDirectory();
        if (dir != null && dir.endsWith(File.separator))
            dir = dir.substring(0, dir.length()-1);
        final String nom = fdlg.getFile();
        if (dir == null)
            chemin = nom;
        else if (nom != null)
            chemin = dir + File.separator + nom;
        if (chemin != null) {
            prefNav = chemin;
            labelNav.setText(nom);
        }
    }
    
    public void defDictionnaire() {
        final FileDialog fdlg = new FileDialog((Frame)getOwner(),
            JaxeResourceBundle.getRB().getString("pref.Dictionnaire"), FileDialog.LOAD);
        fdlg.setFilenameFilter(new ExtFilter("dico"));
        fdlg.setDirectory(System.getProperty("user.dir") + File.separator + "dicos");
        fdlg.setVisible(true);
        String chemin = null;
        String dir = fdlg.getDirectory();
        if (dir != null && dir.endsWith(File.separator))
            dir = dir.substring(0, dir.length()-1);
        String nom = fdlg.getFile();
        if (dir == null)
            chemin = nom;
        else if (nom != null)
            chemin = dir + File.separator + nom;
        if (chemin != null) {
            prefDico = chemin;
            if (nom != null) {
                final int pp = nom.lastIndexOf('.');
                if (pp != -1)
                    nom = nom.substring(0, pp);
            }
            labelDico.setText(nom);
        }
    }
    
    class ExtFilter implements FilenameFilter {
        String[] exta;
        public ExtFilter(final String ext) {
            exta = new String[1];
            exta[0] = ext;
        }
        public ExtFilter(final String[] exta) {
            this.exta = exta;
        }
        public boolean accept(final File dir, final String name) {
            for (final String element : exta)
                if (name.endsWith("." + element))
                    return(true);
            return(false);
        }
    }
}
