<?
/* Interfaces Autodiscovery
 * Copyright (C) <2002,2003> Javier Szyszlican <javier@szysz.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

    $jffnms_functions_include="engine";
    include_once("../conf/config.php");

    function ad_show_interface ($fields,$data) {
	$fields = array_merge(array(array("name"=>"interface", "ftype"=>1, "ftype_handler"=>"none")),$fields);	

	$text = array();   
	foreach ($fields as $fdata)
	    if (isset($fdata["ftype"]) && ($fdata["ftype"]!=3) && isset($fdata["ftype_handler"]) && ($fdata["ftype_handler"]!="bool"))
		$text[] = substr($fdata["name"],0,4).": ".(isset($data[$fdata["name"]])?$data[$fdata["name"]]:"");

	$text = join(" | ",$text);
	return $text;
    }


    $administrative_type_id=$jffnms_administrative_type; //FIXME convert to a define

    if (empty($host_id)) $host_id = $_SERVER["argv"][1];
    if (empty($type_id)) $type_id = $_SERVER["argv"][2];  //filter by interface type
    if (empty($type_id)) $type_id = 0;

    $log_events_option = $_SERVER["argv"][3];
    if (empty($log_events)) $log_events = ($log_events_option=="nolog")?false:true;  //Do not insert events
    
    //satellite
    if ($jffnms_satellite_uri=="none") $my_sat_id = 1; //Only Master Configuration, no satellites
    else $my_sat_id = satellite_get_id($jffnms_satellite_uri);

    if (!$my_sat_id) $my_sat_id = 1; //only master but with URL set


    if (!$host_id) {
	$query_hosts="SELECT id, satellite FROM hosts WHERE autodiscovery > 1 and poll = 1";
	$result_hosts = db_query ($query_hosts) or die ("Query failed - R2 - ".db_error());

	while ($host = db_fetch_array($result_hosts)) {
	
	    $paths = satellite_get_paths($host["satellite"]);
	    
	    if (is_array($paths))
		$paths = satellite_get_first_distribution_path($paths);
	    else
		if ($host["satellite"] == $my_sat_id) //local
		    $paths[]=$my_sat_id;

	    if (is_array($paths))
	    foreach ($paths as $sat_id) 
		if ($sat_id==$my_sat_id) { //local: I'm the one defined to poll this host
		
		    spawn (false, $host["id"]." $type_id $log_events_option",1); //spawn myself if I'm not already running
		    sleep(5); //wait before spawning new proceses
		}
	}
	
	db_close();
	exit;
    }

    $ad_time = time_usec();

    $query_hosts="
	SELECT 	hosts.id, hosts.ip, hosts.rocommunity, hosts.autodiscovery_default_customer,
		autodiscovery.poller_default, autodiscovery.permit_add, autodiscovery.permit_del,
		autodiscovery.permit_mod, autodiscovery.permit_disable, autodiscovery.skip_loopback,
		autodiscovery.check_state, autodiscovery.check_address, autodiscovery.alert_del
	FROM	hosts,autodiscovery where hosts.id = $host_id and hosts.autodiscovery = autodiscovery.id";
    $result_hosts = db_query ($query_hosts) or die ("Query failed - autodiscovery hosts data - ".db_error());

    while ($host_info = db_fetch_array($result_hosts)) { //this should return only one host

	if ($type_id > 1) $type_filter = " and id = $type_id"; else unset($type_filter);
	$query_ad="
	    SELECT 	id, autodiscovery_validate, autodiscovery_function, autodiscovery_parameters, 
			autodiscovery_default_poller, description, sla_default
	    FROM 	interface_types
	    WHERE 	autodiscovery_enabled = 1 $type_filter
	    ORDER BY	id";
	$result_ad = db_query ($query_ad) or die ("Query failed - autodiscovery interface types - ".db_error());

	while ($it = db_fetch_array($result_ad)) { //loop thru all interface_types
	    unset($db);
	    unset($host);
	    
	    logger(	"H ".str_pad($host_info["id"],3," ",STR_PAD_LEFT)." : ".
			"IT ".str_pad($it["id"],3," ",STR_PAD_LEFT)." : ".
			"Autodiscovering ".$it["description"]."\n");

	    //Get All nedded data for this interface type
	    
	    $db   = hosts_interfaces_from_db ($host_info["id"],$it["id"]);
	
	    $host = hosts_interfaces_from_discovery ($it["autodiscovery_function"], $host_info["ip"], $host_info["rocommunity"], $host_info["id"], $it["autodiscovery_parameters"]);

	    $fields = interface_types_fields_list (NULL,array("itype"=>$it["id"],"exclude_types"=>20));
	    
	    //print_r($db);
	    //print_r($host);
	    //print_r ($fields);
	    
	    if (is_array($host)) { //merge the keys to get a single list of all interfaces on both lists
		$interface_ids_list = array_unique(array_merge(array_keys($db),array_keys($host)));
		asort($interface_ids_list);
		reset($interface_ids_list);
	    }
	    
	    if (is_array($host) && (count($host) > 0)) //if the host aswered something  
	    foreach ($interface_ids_list as $key) if ($key >= 0) { //key is valid 
		$processed = 0;
		$now_date = date("Y-m-d H:i:s",time());
		
		if (isset($db[$key])) 	 ksort($db[$key]);
		if (isset($host[$key])) ksort($host[$key]);

		//output
		logger(	"H ".str_pad($host_info["id"],3," ",STR_PAD_LEFT)." : ".
			"IT ".str_pad($it["id"],3," ",STR_PAD_LEFT)." : ".
			"I ".str_pad($key,4," ",STR_PAD_LEFT)." : ".
			"DB  : ".(isset($db[$key])?ad_show_interface($fields,$db[$key]):"Not Found")."\n");
		logger(	"H ".str_pad($host_info["id"],3," ",STR_PAD_LEFT)." : ".
			"IT ".str_pad($it["id"],3," ",STR_PAD_LEFT)." : ".
			"I ".str_pad($key,4," ",STR_PAD_LEFT)." : ".
			"HOST: ".(isset($host[$key])?ad_show_interface($fields,$host[$key]):"Not Found")."\n");

		if (!isset($db[$key]) && isset($host[$key])) {  //not found in DB and found in Host, add
		    if (    ($it["autodiscovery_validate"]==0) ||  //the interface type told us not to validate the data
			    ( //validation	    
				(//loopback test
				($host_info["skip_loopback"]==0) ||	//the policy says not to skip loopbacks
				    ( //check if the interface is loopback
				    (strpos(strtolower($host[$key]["interface"]),"loopback") === false) && //cisco
				    (strpos(strtolower($host[$key]["interface"]),"null") === false) && //cisco
				    ($host[$key]["address"] != "127.0.0.1") && //any loopback
				    (substr(strtolower($host[$key]["interface"]),0,2) != "lo") //linux
				    ) //TRUE if its not a loopback
				) && 
				( //check address
				($host_info["check_address"]==0) || 			//the policy tell us not to check if the address is valid
				(array_key_exists("address",$host[$key]) == false) || 	//or the host doesn't have an address field
				    (($host[$key]["address"]!="") && ($host[$key]["address"]!="0.0.0.0"))  //or the interface has a valid IP address 
				) &&
				( //check status
				($host_info["check_state"]==0) || //the host autodiscovery policy tell us not to check state	
				    (alarm_lookup($host[$key]["oper"])==ALARM_UP) //or the state is UP
				)
			    ) //end of validation
			) { //add the interface

			unset ($text);
	
			logger(	"H ".str_pad($host_info["id"],3," ",STR_PAD_LEFT)." : ".
				"IT ".str_pad($it["id"],3," ",STR_PAD_LEFT)." : ".
				"I ".str_pad($key,4," ",STR_PAD_LEFT)." : ".
				"RES : New Interface Found\n");
			
			if ($host_info["permit_add"]==1) { //fi the AD policy permits adding an interface.
			    
			    if ($host_info["poller_default"]==1) //if the AD policy says use default poller
				ad_set_default (&$host[$key]["poll"],$it["autodiscovery_default_poller"]); //use the interface type default poller for this new interface
		
			    ad_set_default (&$host[$key]["client"],$host_info["autodiscovery_default_customer"]);
			    ad_set_default (&$host[$key]["sla"],$it["sla_default"]);
			    
			    //Find the Index Field
			    foreach ($fields as $fdata)
				if ($fdata["ftype"]==3)
				    $index_field = $fdata["name"];

			    //add the index field as data to use when adding a record
			    $host[$key][$index_field]=$key;

			    //delete the status fields, because they will not be found in the db
			    unset ($host[$key]["admin"]);
			    unset ($host[$key]["oper"]);

			    $interface_id = adm_interfaces_add(array("host"=>$host_info["id"],"type"=>$it["id"])); //add new record
			    adm_interfaces_update($interface_id,$host[$key]); //update it with the data
			    $text = "- Added";
			}
			
			if ($log_events==true)
			    insert_event ($now_date, $administrative_type_id, $host_info["id"], $host[$key]["interface"], //add informative event
				"alert","autodiscovery",trim("Found $text"),0); 
			$processed = 1;
		    }
		}
	
		if ( !isset($host[$key]) && isset($db[$key]) && //found in DB but not in host
		    ($it["autodiscovery_validate"]==1) && ($db[$key]["poll"] > 1)){  //IT need validation, and the interface is being polled (preserve non polling)
		
			logger(	"H ".str_pad($host_info["id"],3," ",STR_PAD_LEFT)." : ".
				"IT ".str_pad($it["id"],3," ",STR_PAD_LEFT)." : ".
				"I ".str_pad($key,4," ",STR_PAD_LEFT)." : ".
				"RES : Not Found in Host\n");
	
			unset ($text);
			if (($host_info["permit_del"]==1) && ($host_info["permit_disable"]==0)) { //Policy permits delete and not disable
			    adm_interfaces_del ($db[$key]["id"]); //delete it
			    $text = "- Deleted";
			}

			if (($host_info["permit_del"]==0) && ($host_info["permit_disable"]==1)) { //policy permits disable but not delete
			    adm_interfaces_update ($db[$key]["id"],array("poll"=>1,"show_rootmap"=>2)); //disable it (No Polling), and mark it disabled on the map
			    $text = "- Disabled";
			}

			if (($log_events==true) && ($host_info["alert_del"]==1))
			    insert_event($now_date,$administrative_type_id, $host_id, $db[$key]["interface"], //add informative event
				"alert","autodiscovery", trim("Not Found in Host $text"),0); 
			$processed = 1;
		}
	
		if (isset($host[$key]) && isset($db[$key]) && ($db[$key]["poll"] > 1)) { //found in both and poll enabled, check for modification

		    //track field changes
		    if ($it["autodiscovery_validate"]==1) { //validate fields in this interface type?
	
			$fields_to_modify = array();
			$track_fields = array();
			
			$track_fields["interface"]="Interface Name";
			
			foreach ($fields as $fdata)
			    if ($fdata["tracked"]==1) 
				$track_fields[$fdata["name"]]=$fdata["description"];

			foreach ($track_fields as $track_field=>$track_field_descr)			
			    if ((!empty($host[$key][$track_field])) && //field from host not empty
		    		(trim(substr($db[$key][$track_field],0,30)) != trim(substr($host[$key][$track_field],0,30))) ) {  //fields not equal

				logger( "H ".str_pad($host_info["id"],3," ",STR_PAD_LEFT)." : ".
					"IT ".str_pad($it["id"],3," ",STR_PAD_LEFT)." : ".
					"I ".str_pad($key,4," ",STR_PAD_LEFT)." : ".
				        "RES : $track_field_descr Changed from ".$db[$key][$track_field]." to ".$host[$key][$track_field]."\n");

				//add field to be modified
				$fields_to_modify[$track_field]=$host[$key][$track_field];
			    }

			if (count($fields_to_modify) > 0) { 	//there are fields to be modified
		
			    $aux_changes = array();
			    
			    foreach ($fields_to_modify as $field_name=>$field_value)
				$aux_changes[] = $track_fields[$field_name]." to ".$field_value." was ".$db[$key][$field_name];
				
			    $aux_changes = join (" and ",$aux_changes);
			    
			    if ($host_info["permit_mod"]==1) { 	//policy permits modification
			    
				adm_interfaces_update ($db[$key]["id"],$fields_to_modify); //modify it
			    
				if (array_key_exists("interface",$fields_to_modify)) //if we changed the interface field (key for events)
				    $aux_interface_name = $host[$key]["interface"]; //use the new one
				else
				    $aux_interface_name = $db[$key]["interface"]; //if not use the old one
			
			        $aux_comment = "- Changed ".$aux_changes;
			    } else {
			        $aux_interface_name = $db[$key]["interface"];
			        $aux_comment = "- NOT Changed ".$aux_changes;
			    }

			    //FIXME this is only for the 0.7.7->0.7.8 upgrade
			    if ((count($fields_to_modify)>1) || 
				((current(array_keys($fields_to_modify))!="mask") &&
				((current(array_keys($fields_to_modify))!="description") && ($aux_interface_name!="CPU")))
			    )
			    if ($log_events==true)
				insert_event($now_date, $administrative_type_id, $host_id, $aux_interface_name,
				    "alert","autodiscovery", trim("detected modification $aux_comment"),0); 
			    $processed = 1;

			    unset ($aux_interface_name);
			    unset ($aux_comment);
			}
			unset($track_fields);
			unset($fields_to_modify);
		    }
		    
		    //no customer selected 
		    if ($db[$key]["client"] <= 1) { //customer not selected in DB
			logger( "H ".str_pad($host_info["id"],3," ",STR_PAD_LEFT)." : ".
				"IT ".str_pad($it["id"],3," ",STR_PAD_LEFT)." : ".
			        "I ".str_pad($key,4," ",STR_PAD_LEFT)." : ".
			        "RES : No Customer Selected\n");

			if ($log_events==true)
			    insert_event($now_date, $administrative_type_id, $host_id, $db[$key]["interface"],
				"alert","autodiscovery","Incomplete Interface Setup (Customer not Selected)",0); 
			$processed = 1;
		    }
		} //modification 
	    
		if ($processed == 0) { //interface was not touched by any posibility
		    logger( "H ".str_pad($host_info["id"],3," ",STR_PAD_LEFT)." : ".
			    "IT ".str_pad($it["id"],3," ",STR_PAD_LEFT)." : ".
			    "I ".str_pad($key,4," ",STR_PAD_LEFT)." : ".
			    "RES : Nothing Done.\n");
		}
		
	    } //for (interface ids)
	} //while (interface types)
    } //while (host)

    $ad_time = time_usec_diff($ad_time);
    logger("H ".str_pad($host_id,3," ",STR_PAD_LEFT)." : Autodiscovery took $ad_time msec.\n");
?>
