<?
    //HOSTMIB Software Running Discovery
    //By: Anders Karlsson <anders.x.karlsson@songnetworks.se>

    function discovery_hostmib_apps($ip,$community, $host_id, $param) {
	$services_table = Array();

	$SWRunName_oid = ".1.3.6.1.2.1.25.4.2.1.2"; 
	$SWRunPath_oid = ".1.3.6.1.2.1.25.4.2.1.4"; 

	//process names you dont want to be autodiscovered, applications with short life and system services (long life)
	$services_manual_add = Array( "bash","sh","php","perl","ash","csh","ksh","CRON","ps","ls",
	"rrdtool","mc","nmap","python2.2","modprobe","snmpwalk","init","bdflush","keventd","kswapd","ksoftirqd_CPU0",
	"System","System Idle Process","kjournald","mdrecoveryd","kupdated","zcat");

	if ($ip && $community && $host_id) { //check for required values
            $services = snmp_walk($ip,$community,$SWRunName_oid);
            $paths = snmp_walk($ip,$community,$SWRunPath_oid);
	    
	    if (is_array($services)) //verify if the array has something
            foreach ( $services as $key=>$service ) {
		$service=trim(str_replace('"','',$service));
		$path=trim(str_replace('"','',$paths[$key]));
		
		if ($service=="init") continue; //FIXME this is a bad hack for this, get the hash better, because it collides with exim
		
		//Service ID is a one-way hash from the process name 
		$service_id = 0;
		$service_hash = $service;

		for ($a=0;$a < strlen($service_hash);$a++)
		    $service_id += ord($service_hash[$a])* //current char
		    ($a+1)+ //position
		    (($a < strlen($service_hash))?ord($service_hash[$a+1]):0)* //next char
		    strlen($service_hash)+ //total length
		    floor(ord($service_hash[0])/30); //based on first char
		
		if (!isset($bug[$service_id][$service])) $bug[$service_id][$service]=1;
		$bug[$service_id][$service]++;
		
		//store first instance data
		if (!isset($services_table[$service_id])) {
            	    $services_table[$service_id]["interface"]=$service;
            	    $services_table[$service_id]["description"]="Application $path";
                
		    //if the process is not in the Manual ADD list, then put it as Oper UP (for autodiscovery)
		    if (!in_array($service,$services_manual_add) && !in_array(basename($path),$services_manual_add))
			$services_table[$service_id]["oper"]="running";
		    else
			$services_table[$service_id]["oper"]="not running";
		}
		
		if (!isset($services_table[$service_id]["instances"])) $services_table[$service_id]["instances"]=0;
                $services_table[$service_id]["instances"]++; //add one more instance
            
    	    }

	    if (isset($bug)) foreach ($bug as $key=>$aux) if (count($aux) > 1) { //BUG Catcher 
		debug ("BUG IN HASH $key, please report it to the JFFNMS developers.\n".
		"You will no be able to monitor the following Applications: ".join (", ",array_keys($aux)).". All others will work fine."); 
	    }
	}

	return $services_table;
    }
?>
