<?
/* Network Autodiscovery
 * Copyright (C) <2004> Javier Szyszlican <javier@szysz.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

    $jffnms_functions_include="engine";
    include_once("../conf/config.php");

    function ip_to_str2 ($ip_ip) {
	$ip_bin = decbin($ip_ip);
	$ip_bin = str_pad($ip_bin,32,"0",STR_PAD_LEFT);
	$parte1 = substr($ip_bin,0,8);
        $parte2 = substr($ip_bin,8,8);
	$parte3 = substr($ip_bin,16,8);
        $parte4 = substr($ip_bin,24,8);
	$string = bindec($parte1).".".bindec($parte2).".".bindec($parte3).".".bindec($parte4);
	return $string;
    }

    function str_to_ip ($strIP){
        $Arr = explode (".",$strIP);
	return ($Arr[3] + $Arr[2] * pow(2,8) + $Arr[1] * pow(2,16) + $Arr[0] * pow(2,24));
    }

    function ip_to_bitsmask ($mask){
	$r = pow(2,32) - $mask;
        $ret = round (32 - (log($r + 1)/log(2)));
	return $ret;
    }
    
    function bitsmask_to_mask ($bmask) {
	$b = round(pow(2,32) - pow(2,32 - $bmask));
	$b = ip_to_str2 ($b);
	return $b;
    }
    
    function ip_same_network ($ip1, $ip2, $mask) {
	$mask_bit = str_to_ip($mask);
    
	$ip1_bit = str_to_ip($ip1);
	$ip2_bit = str_to_ip($ip2);

	$net1_bit = $ip1_bit & $mask_bit;
	$net2_bit = $ip2_bit & $mask_bit;
    
	if ($net1_bit == $net2_bit) return true;
	
	return false;
    }
	    
    function nad_add_network ($ip, $mask, $deep, $parent_net, $seed_id) {

	if (empty($mask)) { // /24
	    list($ip, $bitmask) = explode("/",$ip);
	    $mask = bitsmask_to_mask ($bitmask);
	}
    
	    $ip_bit = str_to_ip($ip);
	    $mask_bit = str_to_ip($mask);

	    $net_bit = $ip_bit & $mask_bit;
	    $net = ip_to_str2 ($net_bit);

	    if ($net != "127.0.0.0") {
		$oper_status = 0;

		$mask_prefix = ip_to_bitsmask ($mask_bit);
	    
		if ($mask_prefix < 24) $mask_prefix = 24;
		
		if ($mask_prefix == 31) $mask_prefix = 32;
	
		if (($mask_prefix == 32) && ($parent_net!=1)) $oper_status = 3;
	    
		$aux ="$net/$mask_prefix";
	
		$networks = nad_load_networks();
		
		/*
		logger ("***** Trying to add Path to network $aux ".
		    (isset($networks["aux"])?"(Alredy added as ".$networks["aux"]["id"].") ":"").
		    "via NET_ID $parent_net, Deep $deep\n");
		*/
		
		if (!isset($networks[$aux]))
		    return db_insert("nad_networks",array("network"=>$aux, "deep"=>$deep, "parent"=>$parent_net, 
			"oper_status"=>$oper_status, "seed"=>$seed_id, "oper_status_changed"=>time()));
		else
		    return $networks[$aux]["id"];	// return the network id
	    }
    }

    function nad_add_ip ($ip, $dns = "", $host = 1, $network = 1, $type = 1) {
	$data = compact("ip","dns","host","type","network");
	return db_insert ("nad_ips",$data);
    }

    function nad_update_ip ($ip_id, $dns, $host, $network, $type = 1) {
	$data = compact("ip","dns","host","type","network");
	return db_update ("nad_ips",$ip_id, $data);
    }

    function nad_del_ip ($ip_id) {
	return db_delete ("nad_ips",$ip_id);
    }

    function nad_add_host () {
	return db_insert ("nad_hosts",array());
    }	

    function nad_update_host ($host_id, $host_data) {
	return db_update("nad_hosts", $host_id, $host_data);
    }

    function nad_load_seeds ($networks) {
	$seeds_query = "SELECT id, seeds, refresh FROM zones where id > 1 and seeds != '' and admin_status = 1";
	$seeds_result = db_query ($seeds_query) or die ("Query Error - ".db_error());

	$something_changed = false;
	while ($rseed = db_fetch_array($seeds_result)) { 		//read each seed
	    $seeds = explode (",",$rseed["seeds"]);

	    foreach ($seeds as $seed) {				//foreach seed
		$seed = trim($seed);

		$total_seeds++;
		
		if (!isset($networks[$seed])) {			//if its not already in the networks list
		    nad_add_network($seed,"",1,1,$rseed["id"]);	//its new, then add it to the DB.
		    $something_changed = true;			//tell the caller that something has changed
		} 
	    }
	}

	if ($total_seeds==0) $something_changed = true;
	
	return $something_changed;	
    }

    function nad_load_networks($network="") {    

	$query_networks = "
	    SELECT nad_networks.*, zones.max_deep, zones.communities, zones.admin_status, zones.refresh 
	    FROM nad_networks, zones
	    WHERE nad_networks.id > 1 AND nad_networks.seed = zones.id ".(!empty($network)?" AND network = '$network'":"");
	$result_networks = db_query ($query_networks) or die ("Query Error - ".db_error());
    
	$networks = array();
	
	while ($rnet = db_fetch_array ($result_networks))
	    $networks[$rnet["network"]] = array ("deep"=>$rnet["deep"], 
		"oper_status"=>$rnet["oper_status"], "admin_status"=>$rnet["admin_status"], "parent"=>$rnet["parent"],
		"id"=>$rnet["id"], "communities"=>explode(",",$rnet["communities"]), "max_deep"=>$rnet["max_deep"],
		"seed"=>$rnet["seed"], "oper_status_changed"=>$rnet["oper_status_changed"], "refresh"=>$rnet["refresh"]);

	return $networks;
    }
    
    function nad_network_status($net_id, $status) {
	return db_update("nad_networks",$net_id, array("oper_status"=>$status, "oper_status_changed"=>time()));
    }

    function nad_load_ips() {    

	$query_ips = "SELECT ip, type FROM nad_ips WHERE id > 1";
	$result_ips = db_query ($query_ips) or die ("Query Error - ".db_error());
    
	$ips = array();
	
	while ($rip = db_fetch_array ($result_ips)) 
	    $ips[$rip["ip"]] = $rip["type"];
    
	return $ips;
    }
    
    function nad_cleanup_network ($net_id) {
	$hosts_query = "SELECT nad_hosts.id FROM nad_hosts, nad_ips 
	    WHERE nad_ips.host = nad_hosts.id AND nad_ips.network = $net_id";
	$hosts_result = db_query ($hosts_query) or die ("Query Error - ".db_error());

	$hosts = array();
	while ($rhost = db_fetch_array($hosts_result))
	    $hosts[]=$rhost["id"];
    
	if (count($hosts) > 0) {
	    $hosts_query = "DELETE FROM nad_hosts WHERE id = ".join(" OR id = ",$hosts);
	    $hosts_result = db_query ($hosts_query) or die ("Query Error - Hosts Delete - ".db_error());
	}
	
	$ips_query = "DELETE FROM nad_ips WHERE network = $net_id";
	$ips_result = db_query ($ips_query) or die ("Query Error - IPS Delete - ".db_error());
	
	return ($ips_result && $hosts_result);
    }
    
    function nad_cleanup () {
	$queries[]="DELETE FROM nad_networks WHERE id > 1";
	$queries[]="DELETE FROM nad_hosts WHERE id > 1";
	$queries[]="DELETE FROM nad_ips WHERE id >1";
	$queries[]="UPDATE nad_networks SET oper_status = 0 WHERE id > 1";
	
	foreach ($queries as $query)
	    $result = db_query($query) or die ("Query Error - Cleanup - ".db_error());

	db_repair("nad_networks");
	db_repair("nad_hosts");
	db_repair("nad_ips");
	
	return $result;
    }


    function discovery_network ($network, $net_data) {
    
	$nmap = get_config_option("nmap_executable");
        $temp = get_config_option("engine_temp_path");
    
	logger ("N ".str_pad($net_data["id"], 4)." : ".
		"Scanning Network $network, deep ".$net_data["deep"]."\n");	
	
	nad_network_status ($net_data["id"],2); //Started
    
	$file = "$temp/".uniqid("na").".dat";
	$aux = "$nmap -sP -PE --randomize_hosts -T4 -oG $file ".str_replace("/32","",$network);
	exec ($aux,$a,$b); 
    
	$data = file ($file);
	unlink ($file);
	
	foreach ($data as $line)
	    if (preg_match ("/Host\: (.*).*\((.*)\).*Status\: (.*)/",trim($line),$parts)) {

		$host_ip = trim($parts[1]);
		$host_name = $parts[2];
		    
		$log =  "N ".str_pad($net_data["id"], 4)." : ".
			"Scanning Host $host_ip";
		
		$host_ip_parts = explode(".",$host_ip);
		
		if (($host_ip_parts[3]!=0) && ($host_ip_parts[3]!=255)) {
		    if ($parts[3]=="Up") {
			if (array_key_exists($host_ip, nad_load_ips())==false) {

			    $host_id = nad_add_host ();

			    logger ($log." Responded to Ping added as H $host_id\n");
		
			    $ip_id = nad_add_ip ($host_ip);
			
			    $ips_found = discovery_host ($host_id, $host_ip, $net_data["communities"], $net_data, $ip_id);
		    
			    if (!$ips_found)
				nad_update_ip ($ip_id, $host_name, $host_id, $net_data["id"], $net_data["seed"]);
			
			} else
			    logger ($log." Already Added\n");
		    } else
			logger ($log." Down\n");
		} else
		    logger ($log." Invalid\n");
	    }
	
	nad_network_status ($net_data["id"],3); //done
    }

    function discovery_host ($host_id, $host_ip, $communities, $net, $host_ip_id) {

	$system_description_oid = ".1.3.6.1.2.1.1.1.0";
	$system_name_oid 	= ".1.3.6.1.2.1.1.5.0";
        $ipadent_oid = ".1.3.6.1.2.1.4.20.1.1";
	$ipadentmask_oid = ".1.3.6.1.2.1.4.20.1.3";
        $ipadentint_oid = ".1.3.6.1.2.1.4.20.1.2";
	$inttype_oid = ".1.3.6.1.2.1.2.2.1.3";
	$ipforwarding_oid = ".1.3.6.1.2.1.4.1.0";
	$ipnettomedia_oid = ".1.3.6.1.2.1.4.22.1.2";
	$intstatus_oid = ".1.3.6.1.2.1.2.2.1.8";

	$invalid_ips = array("127.0.0.1","0.0.0.0");
	$result = false;

	while ((list (, $comm) = each ($communities)) && (!$snmp_name))
	    
	    if (($snmp_name = snmp_get($host_ip, $comm, $system_name_oid, 1))!==false) {

		$log =  "N ".str_pad($net["id"], 4)." : H ".str_pad($host_id,3)." : ";
		logger ($log." Has SNMP $comm - $snmp_name\n");

		$snmp_ips_data = snmp_walk ($host_ip, $comm, $ipadent_oid);

		if ($snmp_ips_data!==false) {

		    $host_ips = array();

		    // Create IPs Table
		    foreach ($snmp_ips_data as $key=>$aux_ip) {
			list(,$aux_ip) = explode (" ",$aux_ip);

			if (!in_array($aux_ip,$invalid_ips)) {

			    if ($aux_ip!=$host_ip) 					// If IP is different than the host IP
				$ip_id = nad_add_ip($aux_ip);				// Add IP to DB
			    else
				$ip_id = $host_ip_id;					// Use ID of the Already added IP
				
			    $host_ips[$aux_ip] = array("ip_id"=>$ip_id , "pos"=>$key); 	//add IP to the Array
			}
		    }
		    unset ($snmp_ips_data);

		    // Do other SNMP reads
		    $snmp_mask_data = snmp_walk ($host_ip, $comm, $ipadentmask_oid);
		    $snmp_int_data  = snmp_walk ($host_ip, $comm, $ipadentint_oid);

		    // Populate the IPs table with Mask and Type data
		    foreach ($host_ips as $aux_ip=>$ipd) {
	
			list(,$aux_mask) = explode (" ",$snmp_mask_data[$ipd["pos"]]);
			if (empty($aux_mask)) $aux_mask = "255.255.255.0"; // Fix for broken IP-MIB implementations
					
			$if_index = $snmp_int_data[$ipd["pos"]];
			list(,$if_status) = split("[()]",snmp_get($host_ip, $comm, $intstatus_oid.".".$if_index));
			
			//$if_status = 1;
			if ($if_status == 1) { // Its UP
			
			    list(,$if_type) = split("[()]",snmp_get($host_ip, $comm, $inttype_oid.".".$if_index));
			    
			    $host_ips[$aux_ip]["mask"] = $aux_mask;
			    $host_ips[$aux_ip]["type"] = $if_type;
			
			} else {	// Its Down
			
			    nad_del_ip($host_ips[$aux_ip]["ip_id"]); // Delete the IP
			    unset ($host_ips[$aux_ip]);
			}
		    }
		    unset ($snmp_mask_data);
		    unset ($snmp_int_data);

		    // Add other IP addresses based on the ARP table (mine not remote)
		    $snmp_physical  = snmp_walk ($host_ip, $comm, $ipnettomedia_oid, 1);

		    if ($snmp_physical != false) {
			
			$snmp_net_to_media = array();	
		    
		        // Make Net-To-Media Table
			foreach ($snmp_physical as $k=>$aux_mac) {
			    $k = explode (".",$k);
			    $aux_ip = join(".",array_slice($k,count($k)-4,4));
			    $snmp_net_to_media[$aux_ip]=$aux_mac;
			    $snmp_media_to_net[$aux_mac][]=$aux_ip;
		        }
			unset ($snmp_physical_data);
		    
			// Find out if there are others ips on the same network with my IP's MAC address (more than 1 IP on the same network)
		        // And add it to the IPs list
			foreach ($host_ips as $ip=>$ipd)
			    if (array_key_exists($ip, $snmp_net_to_media))
				foreach ($snmp_media_to_net[$snmp_net_to_media[$ip]] as $new_ip) 
				    if (!array_key_exists($new_ip,$host_ips) && ip_same_network($ip, $new_ip, $ipd["mask"])) {
					
					$host_ips[$new_ip] = $ipd; 				//copy the other type and mask
					$host_ips[$new_ip]["ip_id"] = nad_add_ip ($new_ip);	//put in my own IP id
				    }
				    
			unset ($snmp_net_to_media);
			unset ($snmp_media_to_net);
		    }
		    
		    foreach ($host_ips as $ip=>$ipd) {
		    
		    	$ipd["dns"] = gethostbyaddr($ip);		// Resolve Reverse DNS for this IP
			if ($ipd["dns"]==$ip) unset ($ipd["dns"]); 	// Do not add the DNS if this IP doesn't have a reverse

			logger ($log." Has IP $ip - ".$ipd["mask"]." - ".$ipd["dns"]."\n");

			$new_net_id = nad_add_network ($ip, $ipd["mask"], $net["deep"]+1, $net["id"], $net["seed"]);

			if (!is_numeric($new_net_id)) $new_net_id = $net["id"];
			    
			nad_update_ip ($ipd["ip_id"], $ipd["dns"], $host_id, $new_net_id, $ipd["type"]);	// Update the IP DB

			$result = true; //we found some ip's
		    }
		
		}	

		// Get Description
		$snmp_description = snmp_get ($host_ip, $comm, $system_description_oid);

		// Findout if the Host has IP Forwarding (Router) Enabled
		list(,$host_forwarding) = split("[()]",snmp_get($host_ip, $comm, $ipforwarding_oid));
		if ($host_forwarding==2) $host_forwarding = 0;
		
		// Update Host information
		nad_update_host ($host_id, array("description"=>$snmp_description, "snmp_name"=>$snmp_name,
			"snmp_community"=>$comm, "forwarding"=>$host_forwarding));
	    }

	return $result;
    }

    function reload_networks ($network = "", $show = true) {
	$network_admin_status=array(0=>"stopped","started");

	$network_oper_status=array(0=>"pending",1=>"starting",2=>"running",3=>"done", 4=>"other path");
	
	$networks = nad_load_networks($network);    

	if (empty($network) && $show) {
	    logger ("Number      Network          Deep/Max         Status       Changed           IDs\n");
	    foreach ($networks as $network=>$net_data)
		logger (
		str_pad(++$i,5," ",STR_PAD_LEFT).
		"\t".str_pad($network,18).
		"\t".str_pad($net_data["deep"]."/".$net_data["max_deep"],7).
		str_pad($network_admin_status[$net_data["admin_status"]].
		"/".$network_oper_status[$net_data["oper_status"]],16).
		" ".str_pad((time()-$net_data["oper_status_changed"])." secs ago",15).
		"\tNID ".str_pad($net_data["id"],5).
		"PID ".$net_data["parent"].
		"\n");

	    logger(str_repeat("=-",45)."\n");
	    reset($networks);
	}
	
	return $networks;	
    }
    
    list (, $start_network) = $_SERVER["argv"];

    if (is_process_running(NULL,2)) 
	die ("Process Already Running.\n");

    if ($start_network=="show") {
	$networks = reload_networks();
	nad_load_seeds($networks);
	reload_networks();
	die();
    }	
    
    $nad_time = time_usec();

    if (!isset($start_network)) {

	$max_running = 15;
	$running = 0;
	$retry_seconds = 60;
	
	nad_cleanup();

	if (nad_load_seeds ($networks)) 			//if there was something changed with the seeds
	    $networks = reload_networks($start_network,true);	//reload the networks

	do {
	    $started = false;

	    reset ($networks);

	    while ((list ($network, $net_data) = each ($networks)) && !$started) {
		
		if (($running < $max_running) && 			//we've less than max already running
		    ($net_data["admin_status"]==1) && 			//its admin started
		    ($net_data["oper_status"]==0) && 			//its oper pending
		    ($net_data["deep"] <= $net_data["max_deep"])) {	//deep is less than max deep

			spawn (NULL,$network); 				//start it
		        nad_network_status ($net_data["id"],1); 	//mark it as Starting
			sleep(1);					//sleep
			$started = true;				//mark as we started something
		    }
	    }
	    
	    $networks = reload_networks();
	    $done = true;
	    $something_changed = false;
	    $running = 0;
	
	    while (list ($network, $net_data) = each ($networks))
		if (($net_data["admin_status"]==1) && 			//if its admin started
		    ($net_data["deep"] <= $net_data["max_deep"])) {	//deep is less than max deep
		    
		    if ($net_data["oper_status"] < 3) 			//if its not done yet
			$done = false;					//we haven't finished
		    
		    if (($net_data["oper_status"] > 0) && 		//if its started and
			($net_data["oper_status"] < 3))			//not done
			$running++;					//count it as running
		
		    if (($net_data["oper_status"] == 1) && 					// if its Starting
			(time()-$net_data["oper_status_changed"] > $retry_seconds)) {		// and has not started for N seconds
		    	    nad_network_status ($net_data["id"],0); 				// mark it as pending
			    $something_changed = true;
		    }

		    if (($net_data["oper_status"] == 2) && 					// if its Running
			(time()-$net_data["oper_status_changed"] > ($retry_seconds*4))) {	// and has not finished for Retry*4 seconds
		    	    nad_network_status ($net_data["id"],0); 				// mark it as pending
			    //nad_cleanup_network ($net_data["id"]);				// Cleanup this network data
			    $something_changed = true;
		    }

		    if (($net_data["oper_status"] == 3) &&					// if its Done
			(time()-$net_data["oper_status_changed"] > $net_data["refresh"])) {	// and has been for more time than refresh
			    nad_network_status ($net_data["id"], 0);				// Mark it as Pending
			    nad_cleanup_network ($net_data["id"]);				// Cleanup this network data
			    $something_changed = true;
		    }
		}

	    if ($something_changed) { 
		$networks = reload_networks($start_network);	//reload the networks
		$done = false;					// we still have job to do
	    }
		
	    if (!$done && !$started && !$something_changed) 	//if we're not done, and we haven't started anything, and nothing has changed
		sleep(10);					//sleep 10
	
	} while (!$done);
    
	$nad_time = round(time_usec_diff($nad_time)/1000);
        logger("Total Network Autodiscovery took $nad_time sec.\n");

    } else { // Discover this specific network

	$networks = reload_networks($start_network,false);

	discovery_network ($start_network, $networks[$start_network]);

	$nad_time = round(time_usec_diff($nad_time)/1000);

    	logger("N ".str_pad($networks[$start_network]["id"], 4)." : Network $start_network Autodiscovery took $nad_time sec.\n");
    }
?>
