/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.openssh.DSAKeyInfo;
import com.sshtools.j2ssh.openssh.PEMReader;
import com.sshtools.j2ssh.openssh.PEMWriter;
import com.sshtools.j2ssh.openssh.RSAKeyInfo;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.util.SimpleASNReader;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;

public class OpenSSHPrivateKeyFormat
implements SshPrivateKeyFormat {
    public String getFormatType() {
        return "OpenSSH-PrivateKey";
    }

    public String toString() {
        return this.getFormatType();
    }

    public byte[] decryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        try {
            StringReader stringReader = new StringReader(new String(byArray, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            byte[] byArray2 = pEMReader.decryptPayload(string);
            SimpleASNReader simpleASNReader = new SimpleASNReader(byArray2);
            if ("DSA PRIVATE KEY".equals(pEMReader.getType())) {
                DSAKeyInfo dSAKeyInfo = DSAKeyInfo.getDSAKeyInfo(simpleASNReader);
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString("ssh-dss");
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getP());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getQ());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getG());
                byteArrayWriter.writeBigInteger(dSAKeyInfo.getX());
                return byteArrayWriter.toByteArray();
            }
            if ("RSA PRIVATE KEY".equals(pEMReader.getType())) {
                RSAKeyInfo rSAKeyInfo = RSAKeyInfo.getRSAKeyInfo(simpleASNReader);
                ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                byteArrayWriter.writeString("ssh-rsa");
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getPublicExponent());
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getModulus());
                byteArrayWriter.writeBigInteger(rSAKeyInfo.getPrivateExponent());
                return byteArrayWriter.toByteArray();
            }
            throw new InvalidSshKeyException("Unsupported type: " + pEMReader.getType());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidSshKeyException("Can't read key due to cryptography problems: " + generalSecurityException);
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException("Can't read key due to internal IO problems: " + iOException);
        }
    }

    public byte[] encryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        try {
            byte[] byArray2;
            Object object;
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string2 = byteArrayReader.readString();
            PEMWriter pEMWriter = new PEMWriter();
            if ("ssh-dss".equals(string2)) {
                object = byteArrayReader.readBigInteger();
                BigInteger bigInteger = byteArrayReader.readBigInteger();
                BigInteger bigInteger2 = byteArrayReader.readBigInteger();
                BigInteger bigInteger3 = byteArrayReader.readBigInteger();
                DSAKeyInfo dSAKeyInfo = new DSAKeyInfo((BigInteger)object, bigInteger, bigInteger2, bigInteger3, BigInteger.ZERO);
                SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
                DSAKeyInfo.writeDSAKeyInfo(simpleASNWriter, dSAKeyInfo);
                byArray2 = simpleASNWriter.toByteArray();
                pEMWriter.setType("DSA PRIVATE KEY");
            } else if ("ssh-rsa".equals(string2)) {
                object = byteArrayReader.readBigInteger();
                BigInteger bigInteger = byteArrayReader.readBigInteger();
                BigInteger bigInteger4 = byteArrayReader.readBigInteger();
                RSAKeyInfo rSAKeyInfo = new RSAKeyInfo(bigInteger, bigInteger4, (BigInteger)object, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO);
                SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
                RSAKeyInfo.writeRSAKeyInfo(simpleASNWriter, rSAKeyInfo);
                byArray2 = simpleASNWriter.toByteArray();
                pEMWriter.setType("RSA PRIVATE KEY");
            } else {
                throw new InvalidSshKeyException("Unsupported J2SSH algorithm: " + string2);
            }
            pEMWriter.setPayload(byArray2);
            pEMWriter.encryptPayload(byArray2, string);
            object = new StringWriter();
            pEMWriter.write((Writer)object);
            return ((StringWriter)object).toString().getBytes("US-ASCII");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidSshKeyException("Can't read key due to cryptography problems: " + generalSecurityException);
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException("Can't read key due to internal IO problems: " + iOException);
        }
    }

    public boolean isFormatted(byte[] byArray) {
        try {
            StringReader stringReader = new StringReader(new String(byArray, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isPassphraseProtected(byte[] byArray) {
        try {
            StringReader stringReader = new StringReader(new String(byArray, "US-ASCII"));
            PEMReader pEMReader = new PEMReader(stringReader);
            return pEMReader.getHeader().containsKey("DEK-Info");
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public boolean supportsAlgorithm(String string) {
        return "ssh-dss".equals(string) || "ssh-rsa".equals(string);
    }
}

