/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.MessageRequestId;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public class SshFxpName
extends SubsystemMessage
implements MessageRequestId {
    public static final int SSH_FXP_NAME = 104;
    private UnsignedInteger32 id;
    private SftpFile[] files;

    public SshFxpName(UnsignedInteger32 unsignedInteger32, SftpFile[] sftpFileArray) {
        super(104);
        this.id = unsignedInteger32;
        this.files = sftpFileArray;
    }

    public SshFxpName() {
        super(104);
    }

    public UnsignedInteger32 getId() {
        return this.id;
    }

    public SftpFile[] getFiles() {
        return this.files;
    }

    public void constructMessage(ByteArrayReader byteArrayReader) throws IOException, InvalidMessageException {
        this.id = byteArrayReader.readUINT32();
        UnsignedInteger32 unsignedInteger32 = byteArrayReader.readUINT32();
        this.files = new SftpFile[unsignedInteger32.intValue()];
        for (int i = 0; i < this.files.length; ++i) {
            String string = byteArrayReader.readString();
            String string2 = byteArrayReader.readString();
            this.files[i] = new SftpFile(string, new FileAttributes(byteArrayReader));
        }
    }

    public String getMessageName() {
        return "SSH_FXP_NAME";
    }

    public void constructByteArray(ByteArrayWriter byteArrayWriter) throws IOException, InvalidMessageException {
        byteArrayWriter.writeUINT32(this.id);
        byteArrayWriter.writeUINT32(new UnsignedInteger32(this.files.length));
        for (int i = 0; i < this.files.length; ++i) {
            byteArrayWriter.writeString(this.files[i].getAbsolutePath());
            byteArrayWriter.writeString(this.files[i].getLongname());
            byteArrayWriter.write(this.files[i].getAttributes().toByteArray());
        }
    }
}

