/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import java.io.IOException;
import java.math.BigInteger;

public abstract class SshKeyExchange {
    protected BigInteger secret;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected byte[] exchangeHash;
    protected byte[] hostKey;
    protected byte[] signature;
    protected TransportProtocol transport;

    public byte[] getExchangeHash() {
        return this.exchangeHash;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public BigInteger getSecret() {
        return this.secret;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void init(TransportProtocol transportProtocol) throws IOException {
        this.transport = transportProtocol;
        this.onInit();
        transportProtocol.addMessageStore(this.messageStore);
    }

    protected abstract void onInit() throws IOException;

    public abstract void performClientExchange(String var1, String var2, byte[] var3, byte[] var4) throws IOException;

    public abstract void performServerExchange(String var1, String var2, byte[] var3, byte[] var4, SshPrivateKey var5) throws IOException;

    public void reset() {
        this.exchangeHash = null;
        this.hostKey = null;
        this.signature = null;
        this.secret = null;
    }
}

