/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPrivateKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes;
    private static Log log;
    private static Vector types;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFormatFactory;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshtoolsPrivateKeyFormat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$openssh$OpenSSHPrivateKeyFormat;

    public static List getSupportedFormats() {
        return types;
    }

    public static void initialize() {
    }

    public static SshPrivateKeyFormat newInstance(String string) throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(string)) {
                return (SshPrivateKeyFormat)((Class)formatTypes.get(string)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + string + " is not supported");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + string);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFormatFactory == null ? (class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFormatFactory = SshPrivateKeyFormatFactory.class$("com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormatFactory")) : class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFormatFactory);
        log.info("Loading private key formats");
        ArrayList<String> arrayList = new ArrayList<String>();
        types = new Vector();
        formatTypes = new HashMap();
        arrayList.add((class$com$sshtools$j2ssh$transport$publickey$SshtoolsPrivateKeyFormat == null ? (class$com$sshtools$j2ssh$transport$publickey$SshtoolsPrivateKeyFormat = SshPrivateKeyFormatFactory.class$("com.sshtools.j2ssh.transport.publickey.SshtoolsPrivateKeyFormat")) : class$com$sshtools$j2ssh$transport$publickey$SshtoolsPrivateKeyFormat).getName());
        arrayList.add((class$com$sshtools$j2ssh$openssh$OpenSSHPrivateKeyFormat == null ? (class$com$sshtools$j2ssh$openssh$OpenSSHPrivateKeyFormat = SshPrivateKeyFormatFactory.class$("com.sshtools.j2ssh.openssh.OpenSSHPrivateKeyFormat")) : class$com$sshtools$j2ssh$openssh$OpenSSHPrivateKeyFormat).getName());
        defaultFormat = "SSHTools-PrivateKey-Base64Encoded";
        try {
            object4 = ConfigurationLoader.getExtensionClassLoader().getResources("j2ssh.privatekey");
            object3 = new Properties();
            while (object4 != null && object4.hasMoreElements()) {
                object2 = object4.nextElement();
                object = ((URL)object2).openStream();
                ((Properties)object3).load((InputStream)object);
                IOUtil.closeStream((InputStream)object);
                int n = 1;
                String string = "";
                while (((Properties)object3).getProperty("privatekey.name." + String.valueOf(n)) != null) {
                    string = ((Properties)object3).getProperty("privatekey.name." + String.valueOf(n));
                    arrayList.add(((Properties)object3).getProperty("privatekey.class." + String.valueOf(n)));
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object3 = (String)object2.next();
            try {
                object = ConfigurationLoader.getExtensionClass((String)object3);
                object4 = (SshPrivateKeyFormat)((Class)object).newInstance();
                log.debug("Installing " + object4.getFormatType() + " private key format");
                formatTypes.put(object4.getFormatType(), object);
                types.add(object4.getFormatType());
            }
            catch (Throwable throwable) {
                log.warn("Private key format implemented by " + (String)object3 + " will not be available", throwable);
            }
        }
    }
}

