/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jcifs.Config;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.util.Base64;

public class NtlmHttpURLConnection
extends HttpURLConnection {
    private static final int MAX_REDIRECTS = Integer.parseInt(System.getProperty("http.maxRedirects", "20"));
    private static final int LM_COMPATIBILITY = Config.getInt("jcifs.smb.lmCompatibility", 0);
    private static final String DEFAULT_DOMAIN;
    private HttpURLConnection connection;
    private Map requestProperties;
    private Map headerFields;
    private ByteArrayOutputStream cachedOutput;
    private String authProperty;
    private String authMethod;
    private boolean handshakeComplete;

    public NtlmHttpURLConnection(HttpURLConnection connection) {
        super(connection.getURL());
        this.connection = connection;
        this.requestProperties = new HashMap();
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connection.connect();
        this.connected = true;
    }

    private void handshake() throws IOException {
        if (this.handshakeComplete) {
            return;
        }
        this.doHandshake();
        this.handshakeComplete = true;
    }

    @Override
    public URL getURL() {
        return this.connection.getURL();
    }

    @Override
    public int getContentLength() {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getContentLength();
    }

    @Override
    public String getContentType() {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getContentType();
    }

    @Override
    public String getContentEncoding() {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getContentEncoding();
    }

    @Override
    public long getExpiration() {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getExpiration();
    }

    @Override
    public long getDate() {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getDate();
    }

    @Override
    public long getLastModified() {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getLastModified();
    }

    @Override
    public String getHeaderField(String header) {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getHeaderField(header);
    }

    /*
     * WARNING - void declaration
     */
    private Map getHeaderFields0() {
        if (this.headerFields != null) {
            return this.headerFields;
        }
        HashMap map = new HashMap();
        String key = this.connection.getHeaderFieldKey(0);
        String value = this.connection.getHeaderField(0);
        int i = 1;
        while (key != null || value != null) {
            void var5_6;
            List list = (List)map.get(key);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                map.put(key, arrayList);
            }
            var5_6.add(value);
            key = this.connection.getHeaderFieldKey(i);
            value = this.connection.getHeaderField(i);
            ++i;
        }
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
        }
        this.headerFields = Collections.unmodifiableMap(map);
        return this.headerFields;
    }

    public Map getHeaderFields() {
        if (this.headerFields != null) {
            return this.headerFields;
        }
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getHeaderFields0();
    }

    @Override
    public int getHeaderFieldInt(String header, int def) {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getHeaderFieldInt(header, def);
    }

    @Override
    public long getHeaderFieldDate(String header, long def) {
        try {
            this.handshake();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return this.connection.getHeaderFieldDate(header, def);
    }

    @Override
    public String getHeaderFieldKey(int index) {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getHeaderFieldKey(index);
    }

    @Override
    public String getHeaderField(int index) {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getHeaderField(index);
    }

    @Override
    public Object getContent() throws IOException {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getContent(classes);
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.connection.getPermission();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        try {
            this.connect();
        }
        catch (IOException ex) {
            // empty catch block
        }
        OutputStream output = this.connection.getOutputStream();
        this.cachedOutput = new ByteArrayOutputStream();
        return new CacheStream(output, this.cachedOutput);
    }

    @Override
    public String toString() {
        return this.connection.toString();
    }

    @Override
    public void setDoInput(boolean doInput) {
        this.connection.setDoInput(doInput);
        this.doInput = doInput;
    }

    @Override
    public boolean getDoInput() {
        return this.connection.getDoInput();
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        this.connection.setDoOutput(doOutput);
        this.doOutput = doOutput;
    }

    @Override
    public boolean getDoOutput() {
        return this.connection.getDoOutput();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        this.connection.setAllowUserInteraction(allowUserInteraction);
        this.allowUserInteraction = allowUserInteraction;
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.connection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.connection.setUseCaches(useCaches);
        this.useCaches = useCaches;
    }

    @Override
    public boolean getUseCaches() {
        return this.connection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        this.connection.setIfModifiedSince(ifModifiedSince);
        this.ifModifiedSince = ifModifiedSince;
    }

    @Override
    public long getIfModifiedSince() {
        return this.connection.getIfModifiedSince();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.connection.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        this.connection.setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        boolean found = false;
        for (Map.Entry entry : this.requestProperties.entrySet()) {
            if (!key.equalsIgnoreCase((String)entry.getKey())) continue;
            entry.setValue(values);
            found = true;
            break;
        }
        if (!found) {
            this.requestProperties.put(key, values);
        }
        this.connection.setRequestProperty(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        List<String> values = null;
        for (Map.Entry entry : this.requestProperties.entrySet()) {
            if (!key.equalsIgnoreCase((String)entry.getKey())) continue;
            values = (List)entry.getValue();
            values.add(value);
            break;
        }
        if (values == null) {
            values = new ArrayList<String>();
            values.add(value);
            this.requestProperties.put(key, values);
        }
        StringBuffer buffer = new StringBuffer();
        Iterator propertyValues = values.iterator();
        while (propertyValues.hasNext()) {
            buffer.append(propertyValues.next());
            if (!propertyValues.hasNext()) continue;
            buffer.append(", ");
        }
        this.connection.setRequestProperty(key, buffer.toString());
    }

    @Override
    public String getRequestProperty(String key) {
        return this.connection.getRequestProperty(key);
    }

    public Map getRequestProperties() {
        HashMap map = new HashMap();
        for (Map.Entry entry : this.requestProperties.entrySet()) {
            map.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void setInstanceFollowRedirects(boolean instanceFollowRedirects) {
        this.connection.setInstanceFollowRedirects(instanceFollowRedirects);
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.connection.getInstanceFollowRedirects();
    }

    @Override
    public void setRequestMethod(String requestMethod) throws ProtocolException {
        this.connection.setRequestMethod(requestMethod);
        this.method = requestMethod;
    }

    @Override
    public String getRequestMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public int getResponseCode() throws IOException {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getResponseMessage();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        this.handshakeComplete = false;
        this.connected = false;
    }

    @Override
    public boolean usingProxy() {
        return this.connection.usingProxy();
    }

    @Override
    public InputStream getErrorStream() {
        try {
            this.handshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connection.getErrorStream();
    }

    private int parseResponseCode() throws IOException {
        try {
            String response = this.connection.getHeaderField(0);
            int index = response.indexOf(32);
            while (response.charAt(index) == ' ') {
                ++index;
            }
            return Integer.parseInt(response.substring(index, index + 3));
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private void doHandshake() throws IOException {
        this.connect();
        try {
            int response = this.parseResponseCode();
            if (response != 401 && response != 407) {
                return;
            }
            Type1Message type1 = (Type1Message)this.attemptNegotiation(response);
            if (type1 == null) {
                return;
            }
            int attempt = 0;
            while (attempt < MAX_REDIRECTS) {
                this.connection.setRequestProperty(this.authProperty, this.authMethod + ' ' + Base64.encode(type1.toByteArray()));
                this.connection.connect();
                response = this.parseResponseCode();
                if (response != 401 && response != 407) {
                    return;
                }
                Type3Message type3 = (Type3Message)this.attemptNegotiation(response);
                if (type3 == null) {
                    return;
                }
                this.connection.setRequestProperty(this.authProperty, this.authMethod + ' ' + Base64.encode(type3.toByteArray()));
                this.connection.connect();
                if (this.cachedOutput != null && this.doOutput) {
                    OutputStream output = this.connection.getOutputStream();
                    this.cachedOutput.writeTo(output);
                    output.flush();
                }
                if ((response = this.parseResponseCode()) != 401 && response != 407) {
                    return;
                }
                if (!this.allowUserInteraction || ++attempt >= MAX_REDIRECTS) break;
                this.reconnect();
            }
            throw new IOException("Unable to negotiate NTLM authentication.");
        }
        finally {
            this.cachedOutput = null;
        }
    }

    private NtlmMessage attemptNegotiation(int response) throws IOException {
        String authHeader;
        this.authProperty = null;
        this.authMethod = null;
        InputStream errorStream = this.connection.getErrorStream();
        if (errorStream != null && errorStream.available() != 0) {
            int count;
            byte[] buf = new byte[1024];
            while ((count = errorStream.read(buf, 0, 1024)) != -1) {
            }
        }
        if (response == 401) {
            authHeader = "WWW-Authenticate";
            this.authProperty = "Authorization";
        } else {
            authHeader = "Proxy-Authenticate";
            this.authProperty = "Proxy-Authorization";
        }
        String authorization = null;
        List methods = (List)this.getHeaderFields0().get(authHeader);
        if (methods == null) {
            return null;
        }
        for (String currentAuthMethod : methods) {
            if (currentAuthMethod.startsWith("NTLM")) {
                if (currentAuthMethod.length() == 4) {
                    this.authMethod = "NTLM";
                    break;
                }
                if (currentAuthMethod.indexOf(32) != 4) continue;
                this.authMethod = "NTLM";
                authorization = currentAuthMethod.substring(5).trim();
                break;
            }
            if (!currentAuthMethod.startsWith("Negotiate")) continue;
            if (currentAuthMethod.length() == 9) {
                this.authMethod = "Negotiate";
                break;
            }
            if (currentAuthMethod.indexOf(32) != 9) continue;
            this.authMethod = "Negotiate";
            authorization = currentAuthMethod.substring(10).trim();
            break;
        }
        if (this.authMethod == null) {
            return null;
        }
        NtlmMessage message = authorization != null ? new Type2Message(Base64.decode(authorization)) : null;
        this.reconnect();
        if (message == null) {
            message = new Type1Message();
            if (LM_COMPATIBILITY > 2) {
                message.setFlag(4, true);
            }
        } else {
            String domain = DEFAULT_DOMAIN;
            String user = Type3Message.getDefaultUser();
            String password = Type3Message.getDefaultPassword();
            String userInfo = this.url.getUserInfo();
            if (userInfo != null) {
                int index = (userInfo = URLDecoder.decode(userInfo)).indexOf(58);
                String string = user = index != -1 ? userInfo.substring(0, index) : userInfo;
                if (index != -1) {
                    password = userInfo.substring(index + 1);
                }
                if ((index = user.indexOf(92)) == -1) {
                    index = user.indexOf(47);
                }
                domain = index != -1 ? user.substring(0, index) : domain;
                String string2 = user = index != -1 ? user.substring(index + 1) : user;
            }
            if (user == null) {
                if (!this.allowUserInteraction) {
                    return null;
                }
                try {
                    PasswordAuthentication auth;
                    URL url = this.getURL();
                    String protocol = url.getProtocol();
                    int port = url.getPort();
                    if (port == -1) {
                        int n = port = "https".equalsIgnoreCase(protocol) ? 443 : 80;
                    }
                    if ((auth = Authenticator.requestPasswordAuthentication(null, port, protocol, "", this.authMethod)) == null) {
                        return null;
                    }
                    user = auth.getUserName();
                    password = new String(auth.getPassword());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            Type2Message type2 = (Type2Message)message;
            message = new Type3Message(type2, password, domain, user, Type3Message.getDefaultWorkstation());
        }
        return message;
    }

    private void reconnect() throws IOException {
        this.connection = (HttpURLConnection)this.connection.getURL().openConnection();
        this.connection.setRequestMethod(this.method);
        this.headerFields = null;
        for (Map.Entry property : this.requestProperties.entrySet()) {
            String key = (String)property.getKey();
            StringBuffer value = new StringBuffer();
            Iterator values = ((List)property.getValue()).iterator();
            while (values.hasNext()) {
                value.append(values.next());
                if (!values.hasNext()) continue;
                value.append(", ");
            }
            this.connection.setRequestProperty(key, value.toString());
        }
        this.connection.setAllowUserInteraction(this.allowUserInteraction);
        this.connection.setDoInput(this.doInput);
        this.connection.setDoOutput(this.doOutput);
        this.connection.setIfModifiedSince(this.ifModifiedSince);
        this.connection.setUseCaches(this.useCaches);
    }

    static {
        String domain = System.getProperty("http.auth.ntlm.domain");
        if (domain == null) {
            domain = Type3Message.getDefaultDomain();
        }
        DEFAULT_DOMAIN = domain;
    }

    private static class CacheStream
    extends OutputStream {
        private final OutputStream stream;
        private final OutputStream collector;

        public CacheStream(OutputStream stream, OutputStream collector) {
            this.stream = stream;
            this.collector = collector;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.collector.close();
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
            this.collector.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.stream.write(b);
            this.collector.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
            this.collector.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
            this.collector.write(b);
        }
    }
}

