/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.system.logging.Log;

public class Shell
extends HFrame
implements Runnable {
    BufferedOutputStream out;
    BufferedReader in;
    BufferedOutputStream err;
    JTextArea text = new JTextArea(25, 101);
    long off;
    Thread runner;
    JScrollPane textP;
    String input = "";
    Vector commands = new Vector();
    int currCmd = 0;

    public Shell(InputStream in, OutputStream out) {
        try {
            this.in = new BufferedReader(new InputStreamReader(in));
            this.out = new BufferedOutputStream(out);
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug("ERROR: " + e.getMessage());
        }
    }

    public Shell(BufferedReader in, OutputStream out) {
        try {
            this.in = in;
            this.out = new BufferedOutputStream(out);
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug("ERROR: " + e.getMessage());
        }
    }

    public void init() throws Exception {
        this.setTitle("Shell");
        this.setDefaultCloseOperation(2);
        HFrame.fixLocation(this);
        this.textP = new JScrollPane(this.text);
        this.text.setFont(new Font("Monospaced", 0, 10));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add("Center", this.textP);
        this.text.setEditable(false);
        this.setBackground(this.text.getBackground());
        DefaultCaret c = new DefaultCaret();
        c.setBlinkRate(1000);
        this.text.setCaret(c);
        this.text.setCaretColor(Color.BLACK);
        c.setVisible(true);
        this.text.setLineWrap(true);
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 && Shell.this.input.length() > 0) {
                    Shell.this.input = Shell.this.input.substring(0, Shell.this.input.length() - 1);
                    String t = Shell.this.text.getText();
                    t = t.substring(0, t.length() - 1);
                    Shell.this.text.setText(t);
                } else if (e.getKeyCode() == 38) {
                    String t = Shell.this.text.getText();
                    t = t.substring(0, t.length() - Shell.this.input.length());
                    if (Shell.this.currCmd <= Shell.this.commands.size() && Shell.this.currCmd > 0) {
                        --Shell.this.currCmd;
                        String cmd = (String)Shell.this.commands.get(Shell.this.currCmd);
                        Shell.this.input = cmd.substring(0, cmd.length() - 1);
                        Shell.this.text.setText(t + Shell.this.input);
                    }
                } else if (e.getKeyCode() == 40) {
                    String t = Shell.this.text.getText();
                    t = t.substring(0, t.length() - Shell.this.input.length());
                    if (Shell.this.currCmd + 1 < Shell.this.commands.size() && Shell.this.currCmd >= 0) {
                        ++Shell.this.currCmd;
                        String cmd = (String)Shell.this.commands.get(Shell.this.currCmd);
                        Shell.this.input = cmd.substring(0, cmd.length() - 1);
                        Shell.this.text.setText(t + Shell.this.input);
                    }
                } else if (e.getKeyCode() != 16 && !e.isActionKey()) {
                    Shell.this.input = Shell.this.input + e.getKeyChar();
                    Shell.this.text.append("" + e.getKeyChar());
                }
                if (e.getKeyCode() == 10) {
                    Shell.this.send();
                }
            }
        });
        this.pack();
        HFrame.fixLocation(this);
        this.setVisible(true);
        this.runner = new Thread(this);
        this.runner.start();
        this.toFront();
        this.text.requestFocus();
    }

    @Override
    public void run() {
        try {
            int i;
            char[] b = new char[4096];
            while ((i = this.in.read(b, 0, b.length)) != -1) {
                this.text.append(new String(b, 0, i));
                while (this.text.getRows() > 500) {
                    String t = this.text.getText();
                    t = t.substring(250);
                    this.text.setText(t);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                JScrollBar bar = this.textP.getVerticalScrollBar();
                bar.setValue(bar.getMaximum());
                this.text.setCaretPosition(this.text.getText().length());
            }
            this.text.setEnabled(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("ERROR: " + ex.getMessage());
            this.dispose();
        }
    }

    private void send() {
        try {
            String msg = this.input;
            this.input = "";
            this.out.write(msg.getBytes());
            this.out.flush();
            this.commands.add(msg);
            this.currCmd = this.commands.size();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Log.debug("ERROR: " + ex.getMessage());
            this.dispose();
        }
    }

    public static void main(String[] argv) {
        try {
            Process p = Runtime.getRuntime().exec(argv.length > 0 ? argv[0] : "/bin/bash");
            new Shell(p.getInputStream(), p.getOutputStream());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

