/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfilechooser;

import com.sun.xfile.XFile;
import com.sun.xfile.XFileInputStream;
import com.sun.xfile.XFileOutputStream;
import com.sun.xfilechooser.BeanXFile;
import com.sun.xfilechooser.XFileSystemView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class XFileChooser
extends JFileChooser
implements PropertyChangeListener {
    private XFile currentXDirectory = new XFile(System.getProperty("user.home"));
    private XFile selectedXFile = null;
    private XFile[] selectedXFiles = null;
    private XFileInputStream selectedXFileInputStream = null;
    private XFileOutputStream selectedXFileOutputStream = null;
    public static final String XDIRECTORY_CHANGED_PROPERTY = "XdirectoryChanged";
    public static final String SELECTED_XFILE_CHANGED_PROPERTY = "SelectedXFileChangedProperty";
    public static final String SELECTED_XFILES_CHANGED_PROPERTY = "SelectedXFilesChangedProperty";

    public XFileChooser() {
        super(XFileSystemView.getFileSystemView());
        this.setApproveButtonToolTipText("");
        this.setApproveButtonText("");
        this.setApproveButtonMnemonic(0);
        this.setDialogTitle("");
        this.setFileSelectionMode(0);
        this.addPropertyChangeListener(this);
    }

    public XFileChooser(XFile currentDirectory) {
        this(currentDirectory == null ? null : currentDirectory.getAbsolutePath());
        this.addPropertyChangeListener(this);
    }

    public XFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath, XFileSystemView.getFileSystemView());
        this.addPropertyChangeListener(this);
    }

    public void ensureFileIsVisible(XFile f) {
        if (f != null) {
            this.ensureFileIsVisible(new File(f.getAbsolutePath()));
        }
    }

    public XFile getCurrentXDirectory() {
        return this.currentXDirectory;
    }

    public XFile getSelectedXFile() {
        return this.selectedXFile;
    }

    public XFileInputStream getSelectedXFileInputStream() {
        XFile f = this.getSelectedXFile();
        try {
            this.selectedXFileInputStream = new XFileInputStream(f);
        }
        catch (Exception exception) {
            this.selectedXFileInputStream = null;
        }
        return this.selectedXFileInputStream;
    }

    public XFileOutputStream getSelectedXFileOutputStream() {
        XFile f = this.getSelectedXFile();
        try {
            this.selectedXFileOutputStream = new XFileOutputStream(f);
        }
        catch (Exception exception) {
            this.selectedXFileOutputStream = null;
        }
        return this.selectedXFileOutputStream;
    }

    public XFile[] getSelectedXFiles() {
        if (this.selectedXFiles == null) {
            return new XFile[0];
        }
        return this.selectedXFiles;
    }

    public static void main(String[] args) {
        XFileChooser xfb = new XFileChooser();
        xfb.showDialog(new JFrame(), "ajacob");
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        Object obj = e.getNewValue();
        if (obj == null || !(obj instanceof BeanXFile)) {
            return;
        }
        BeanXFile bf = (BeanXFile)obj;
        if (prop == "directoryChanged") {
            XFile oldValue = this.currentXDirectory;
            this.currentXDirectory = new XFile(((BeanXFile)obj).getAbsolutePath());
            this.firePropertyChange(XDIRECTORY_CHANGED_PROPERTY, oldValue, this.currentXDirectory);
        } else if (prop == "SelectedFileChangedProperty") {
            XFile oldValue = this.selectedXFile;
            this.selectedXFile = new XFile(((File)obj).getAbsolutePath());
            this.firePropertyChange(SELECTED_XFILES_CHANGED_PROPERTY, oldValue, this.selectedXFile);
        } else if (prop == "SelectedFilesChangedProperty") {
            XFile[] oldValue = this.selectedXFiles;
            File[] sfiles = (File[])obj;
            int i = 0;
            while (i < sfiles.length) {
                this.selectedXFiles[i] = new XFile(sfiles[i].getAbsolutePath());
                ++i;
            }
            this.firePropertyChange(SELECTED_XFILES_CHANGED_PROPERTY, oldValue, this.selectedXFiles);
        }
    }

    public void setCurrentXDirectory(XFile currentDirectory) {
        if (currentDirectory != null) {
            this.currentXDirectory = currentDirectory;
            this.setCurrentDirectory(new BeanXFile(currentDirectory.getAbsolutePath()));
        } else {
            this.setCurrentDirectory(null);
        }
    }

    public void setSelectedXFile(XFile selectedFile) {
        this.selectedXFile = selectedFile;
        if (selectedFile != null) {
            this.setSelectedFile(new BeanXFile(selectedFile.getAbsolutePath()));
        } else {
            this.setSelectedFile(null);
        }
    }

    public void setSelectedXFiles(XFile[] selectedFiles) {
        this.selectedXFiles = selectedFiles;
        if (selectedFiles != null) {
            File[] sfiles = new BeanXFile[selectedFiles.length];
            int i = 0;
            while (i < selectedFiles.length) {
                sfiles[i] = new BeanXFile(selectedFiles[i].getAbsolutePath());
                ++i;
            }
            this.setSelectedFiles(sfiles);
        } else {
            this.setSelectedFiles(null);
        }
    }
}

