/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.tools;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jftp.JFtp;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.HTextField;
import net.sf.jftp.system.LocalIO;
import net.sf.jftp.system.logging.Log;
import net.sf.jftp.tools.Holer;

public class HttpSpider
extends HPanel
implements Runnable,
ActionListener {
    private HTextField host = new HTextField("Full URL:", "http://j-ftp.sourceforge.net/index.html", 30);
    private HTextField type = new HTextField("Types (use * for all):", "html-htm-css-gif-jpg-zip-gz-avi-mpg", 25);
    private HTextField depth = new HTextField("Search up to this many levels deeper:", "1", 10);
    private HTextField dir = new HTextField("Store files in:", "", 25);
    private JPanel p1 = new JPanel();
    private JPanel okP = new JPanel();
    private JButton ok = new JButton("Start");
    private int currentDepth = 0;
    private int MAX = 1;
    private String[] typeArray = new String[]{"mpg", "avi", "mpeg", "mov", "rm", "wmv"};
    private String localDir = ".";
    private String[] argv;
    private Thread runner;
    private boolean stopflag = false;
    private JButton stop = new JButton("Stop download (ASAP)");

    public HttpSpider(String localDir) {
        this.localDir = localDir;
        this.setLayout(new BorderLayout());
        this.p1.setLayout(new GridLayout(4, 1, 5, 5));
        this.p1.add(this.host);
        this.p1.add(this.type);
        this.p1.add(this.depth);
        this.dir.setText(localDir);
        this.p1.add(this.dir);
        this.add("Center", this.p1);
        this.add("South", this.okP);
        this.okP.add(this.ok);
        this.ok.addActionListener(this);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.localDir = this.dir.getText();
            if (!this.localDir.endsWith("/")) {
                this.localDir = this.localDir + "/";
            }
            String[] argv2 = new String[]{this.host.getText().trim(), this.type.getText().trim(), this.depth.getText().trim()};
            this.argv = argv2;
            this.removeAll();
            this.add("North", new JLabel("Starting download, please watch the log window for details"));
            this.add("Center", this.stop);
            this.stop.addActionListener(this);
            JFtp.statusP.jftp.setClosable(this.hashCode(), false);
            this.validate();
            this.runner = new Thread(this);
            this.runner.start();
        } else if (e.getSource() == this.stop) {
            this.stopflag = true;
        }
    }

    @Override
    public void run() {
        this.spider(this.argv);
        if (!this.stopflag) {
            Log.debug("\nRecursive download finished.\nOuptut dir: " + this.localDir);
        } else {
            Log.debug("\nRecursive download aborted.");
        }
        JFtp.statusP.jftp.ensureLogging();
        JFtp.statusP.jftp.removeFromDesktop(this.hashCode());
    }

    private void spider(String[] argv) {
        try {
            String url = "http://j-ftp.sourceforge.net/index.html";
            if (argv.length >= 2) {
                url = this.clear(argv[0]);
                if (url.indexOf("/") < 0) {
                    url = url + "/";
                }
                this.typeArray = this.check(argv[1]);
                Log.debugRaw(">>> Scanning for ");
                for (int i = 0; i < this.typeArray.length; ++i) {
                    Log.debugRaw(this.typeArray[i] + " ");
                }
                Log.debug("");
            }
            if (argv.length > 2) {
                this.MAX = Integer.parseInt(argv[2]);
            }
            if (this.stopflag) {
                return;
            }
            Log.debug("Fetching initial HTML file...");
            Holer sammy = new Holer(this.localDir);
            sammy.bringAnStart(url, true);
            if (this.stopflag) {
                return;
            }
            Log.debug("Searching for links...");
            JFtp.statusP.jftp.ensureLogging();
            LocalIO.pause(500);
            if (this.stopflag) {
                return;
            }
            this.smoke(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String clear(String url) {
        int idx = url.indexOf("http://");
        if (idx >= 0) {
            url = url.substring(7);
        }
        return url;
    }

    private Vector addVector(Vector v, Vector x) {
        Enumeration e = x.elements();
        while (e.hasMoreElements()) {
            String next = (String)e.nextElement();
            v.add(next);
        }
        return v;
    }

    private void smoke(String url) throws Exception {
        if (this.stopflag) {
            return;
        }
        url = this.clear(url);
        Holer sammy = new Holer(this.localDir);
        String zeug = sammy.holZeug(url);
        Vector m = this.sortiermal(zeug, url.substring(0, url.lastIndexOf("/")), "href=\"");
        m = this.addVector(m, this.sortiermal(zeug, url.substring(0, url.lastIndexOf("/")), "src=\""));
        m = this.addVector(m, this.sortiermal(zeug, url.substring(0, url.lastIndexOf("/")), "HREF=\""));
        m = this.addVector(m, this.sortiermal(zeug, url.substring(0, url.lastIndexOf("/")), "SRC=\""));
        Enumeration mischen = m.elements();
        while (mischen.hasMoreElements()) {
            if (this.stopflag) {
                return;
            }
            String next = (String)mischen.nextElement();
            Log.out("Processing: " + next);
            for (int i = 0; i < this.typeArray.length; ++i) {
                int x;
                if (!next.endsWith(this.typeArray[i]) && !this.typeArray[i].trim().equals("*") || (x = next.indexOf("/")) <= 0 || next.substring(0, x).indexOf(".") <= 0) continue;
                Holer nochnsammy = new Holer(this.localDir);
                nochnsammy.bringAnStart(next, false);
                if (!this.stopflag) continue;
                return;
            }
            if (this.currentDepth >= this.MAX) continue;
            if (this.stopflag) {
                return;
            }
            int x = next.indexOf("/");
            if (x <= 0 || next.substring(0, x).indexOf(".") <= 0) continue;
            ++this.currentDepth;
            this.smoke(next);
            --this.currentDepth;
        }
    }

    private Vector sortiermal(String zeug, String url, String index) {
        Vector<String> mischen = new Vector<String>();
        int wo = 0;
        while ((wo = zeug.indexOf(index)) >= 0) {
            zeug = zeug.substring(wo + index.length());
            String was = zeug.substring(0, zeug.indexOf("\""));
            was = this.checker(was, url);
            mischen.add(was);
            Log.out("Added: " + was);
        }
        return mischen;
    }

    private String[] check(String auswahl) {
        StringTokenizer flyer = new StringTokenizer(auswahl, "-", false);
        String[] einkauf = new String[flyer.countTokens()];
        int tmp = 0;
        while (flyer.hasMoreElements()) {
            einkauf[tmp] = (String)flyer.nextElement();
            ++tmp;
        }
        return einkauf;
    }

    private String checker(String was, String url) {
        if ((was = this.clear(was)).startsWith(url)) {
            return was;
        }
        if (was.startsWith("/") && url.indexOf("/") > 0) {
            was = url.substring(0, url.indexOf("/")) + was;
        } else if (was.startsWith("/") && url.indexOf("/") < 0) {
            was = url + was;
        } else if (was.indexOf(".") > 0) {
            int idx = was.indexOf("/");
            String tmp = "";
            if (idx >= 0) {
                tmp = was.substring(0, idx);
            }
            if (tmp.indexOf(".") > 0) {
                return this.clear(was);
            }
            was = url.endsWith("/") ? url + was : url + "/" + was;
        }
        Log.out("-> " + was);
        return was;
    }

    @Override
    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }
}

