#ifndef JVM_H__
#define JVM_H__

void call_method_entry (JNIEnv* thread_env_id, jmethodID mid);

void call_method_exit (JNIEnv* thread_env_id, jmethodID mid);

void call_object_alloc (JNIEnv* thread_env_id, jint arena_id, 
			       jobjectID class_id, jint is_array, 
			       jint size, jobjectID obj_id);

void call_object_move (JNIEnv* thread_env_id, 
		       jint arena_id, jobjectID obj_id, 
		       jint new_arena_id, jobjectID new_obj_id);

void call_object_free (JNIEnv* thread_env_id, 
		       jobjectID obj_id);

void call_gc_start (JNIEnv* thread_env_id);

void call_gc_finish (JNIEnv* thread_env_id, 
		     jlong used_objects, 
		     jlong used_object_space, 
		     jlong total_object_space);

#endif /* JVM_H__ */
