/** 
 *  ObjectStore a pool for objects.
 */
#ifndef OBJECTSTORE_H__
#define OBJECTSTORE_H__

#include <jni.h>
#include <jvmpi.h>
#include <obj.h>
#include <cls.h>
#include <method.h>

typedef struct objectstore objectstore;

/** The objects stored in the objectstore */
typedef union obj_obs obj_obs;

union obj_obs {
    obj o;
    obj_obs* next_free;
};

/** The buffers the object store consists of. */
typedef struct obj_buffer obj_buffer;
struct obj_buffer {
    obj_obs*    buf;
    obj_buffer* next;    
};

/** The object store. */
struct objectstore {
    obj_obs*     free_list;  /** The list of free objects */
    obj_buffer*  buf;        /** The list of used objects */ 
    size_t       size;       /** The current number of used objects. */
};

/** Create a new objectstore.
 */
objectstore* objectstore_new ();

/** Delete the given objectstore. */
void objectstore_free (objectstore* os);

/** Create a new object on the objectstore.
 */
obj* objectstore_obj_new (objectstore* os, jint arena_id, cls* class_id, 
			  jint is_array, jint size, jobjectID obj_id, 
			  method* method, int reset_level, int gc_level);

/** Destroy an object on the objectstore
 */
void objectstore_obj_free (objectstore* os, obj* o);

#endif /* OBJECTSTORE_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
