#ifndef UI_GTK_H__
#define UI_GTK_H__

#include <hash.h>
#include <deadlock_detector.h>

enum {
    OCLASS_COLUMN,
    OINSTANCE_COLUMN,
    OINSTANCE_MAX_COLUMN,
    OSIZE_COLUMN,
    OGC_COLUMN,
    OTENURE_COLUMN,
    OOBJECT_COLUMN,  /* pointer to the cls, please keep next to last */
    ON_COLUMNS
};

extern int exit_on_jvm_shutdown;

/** do ui clean. */
void end_ui (void);

/** do any special ui initialization. */
void init_ui (void);

/** The thread used to run gtk-main. 
 */
void gtkthread (void* data);

/** Tell the ui system to shutdown and wait for it to do so. */
int quit_ui (void);

/** Tell the ui system it can startup. */
void start_ui (void);

/** Tell the ui the jvm has shutdown */
void notify_profile_window_begin_ui (void);
void notify_profile_window_end_ui (void);
void notify_profile_window_close_ui (void);
void notify_jvm_shutdown_ui (void);
void notify_update_full_try_ui (void);

/** Tell the ui system it should shutdown. */
void stop_ui (void);

/** Update the statistics. */
void updateUI (hashtab* cls, hashtab* methods);

/** Return the id of the dump file. */
int dump_data (char* dumpfile, hashtab* cls, hashtab* methods, hashtab* threads);

/** Set the dump timer... */
void set_dump_timer (int dumptimer);

/** Get the current dump timer. */
int get_dump_timer (void);

/** Set the status text on the main status bar, we're threadsafe. */
void set_status (const char* text);

/** Check if we have any ui-handling to do. */
int events_pending (void);

/** Update the ui-toolkit (gtk_main_iteration ()) */
int ui_iteration (void);

/** Are we initialising or already running */
int ui_gtk_state (void);

/** Show deadlock */
void show_deadlock (visited_threads* vt);

extern void show_objects_alloced_by_method (hashtab* objects, method* m, int minimum_level);
extern void show_objects_alloced_by_class (hashtab* objects, cls* c, int minimum_level);
extern void show_instance_owners (hashtab* objects, cls* c);
extern void show_owner_for_object (hashtab* objects, obj* o);
extern void show_owners_statistics (hashtab* objects, cls* c);

#endif /* UI_GTK_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
