#include <jmp-config.h>

#include <gtk/gtk.h>

#include <jmp.h>
#include <jmp-debug.h>
#include <cls.h>
#include <heap_dump.h>

#include <ui_gtk.h>
#include <ui_gtk_class_info.h>
#include <ui_gtk_filtermenu.h>
#include <ui_gtk_gtkutils.h>
#include <ui_gtk_string_inspector.h>
#include <ui_gtk_classlist_menu.h>

static cls* c;

void olist_row_changed (GtkTreeSelection *selection, gpointer data) {
    GtkTreeIter iter;
    GtkTreeModel *model;
    
    if (gtk_tree_selection_get_selected (selection, &model, &iter)) 
	gtk_tree_model_get (model, &iter, OOBJECT_COLUMN, &c, -1);
    else 
	c = NULL;
}

/** request to show all live objects by a certain class. */
static void omenu_show_alloced (GtkObject *object_list) {
    if (c != NULL)
	run_show_objects_alloced_by_class (c);
}

/** request to show all owners of a given class type. */
static void omenu_find_owners (GtkObject *object_list) {
    cls* cp = c;
    if (cp != NULL) {
	if (!is_get_owners_possible ())
	    run_heap_dump ();
	run_find_owners (cp);
    }
}

/** request to show all owners of a given class type. */
static void omenu_owners_statistics (GtkObject *object_list) {
    cls* cp = c;
    if (cp != NULL) {
	if (!is_get_owners_possible ())
	    run_heap_dump ();
	run_owners_statistics (cp);
    }
}

/** request to show information about a given class */
static void omenu_inspect_class (GtkObject *object_list) {
    if (c != NULL) {
	show_class_info (c);
    }
}

static void omenu_show_strings (GtkObject *object_list) {
    inspect_strings ();
}

/** Build a menu to show the options avialable on a class.
 */
static GtkWidget *build_omenu (GtkWidget* object_list) {
    GtkWidget *menuitem;
    GtkWidget *filters;
    GtkWidget *omenu = gtk_menu_new ();
    add_menu_item (omenu, _("show alloc'ed instances"), (GCallback)omenu_show_alloced);
    add_menu_separator (omenu);
    add_menu_item (omenu, _("Show object owners"), (GCallback)omenu_find_owners);
    add_menu_item (omenu, _("Show object owners statistics"), (GCallback)omenu_owners_statistics);
    add_menu_separator (omenu);
    add_menu_item (omenu, _("Inspect class"), (GCallback)omenu_inspect_class);
    add_menu_separator (omenu);
    add_menu_item (omenu, _("Show strings"), (GCallback)omenu_show_strings);
    add_menu_separator (omenu);
    /* add filters... */
    filters = build_filter_menu (c);
    menuitem = gtk_menu_item_new_with_label (_("Filter"));
    gtk_menu_append (GTK_MENU (omenu), menuitem);
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), filters);
    gtk_widget_show_all (omenu);
    return omenu;
}

gint olist_button_handler (GtkWidget *widget,
			   GdkEventButton *event,
			   gpointer  callback_data) {
    if (event->button == 3 && c != NULL) {
	GtkWidget* omenu = build_omenu (widget);
	gtk_menu_popup (GTK_MENU (omenu), NULL, NULL, NULL, NULL,
                        event->button, event->time);	
	return TRUE;
    }
    return FALSE;
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
