#include <jmp-config.h>

#include <gtk/gtk.h>

#include <jmp.h>
#include <hash.h>
#include <heap_dump.h>
#include <jmpthread.h>

#include <ui_gtk_gtkutils.h>
#include <ui_gtk_monitor_dialog.h>

/** Temporary buffer for labeling. */
#define BLEN 32
static char buf[BLEN];

static char* get_monitor_name (monitor_info* mi) {
    return mi->name;
}

static char* get_monitor_id (monitor_info* mi) {
    snprintf (buf, BLEN, "%p", mi->id);
    return buf;    
}

/** return a safe string for the name of the thread. */
static char* get_thread_name (jmpthread* t) {
    return t ? jmpthread_get_thread_name (t) : _("<unknown>");
}

static char* get_monitor_owner (monitor_info* mi) {
    return get_thread_name (mi->owner);
}

static char* get_monitor_entry_count (monitor_info* mi) {
    snprintf (buf, BLEN, "%d", mi->entry_count);	/* WIN32 wants: %ld */
    return buf;        
}

static void add_threads_to_frame (int num, jmpthread** threads, GtkWidget* frametable) {
    int j = 0;
    for (j = 0; j < num; j++) {
	add_left_label_to_table (get_thread_name (threads[j]), frametable, j, 0);
	snprintf (buf, BLEN, "id: %p", jmpthread_get_env_id (threads[j]));
	add_left_label_to_table (buf, frametable, j, 1);
	add_left_label_to_table (jmpthread_get_group_name (threads[j]), frametable, j, 2);
	add_left_label_to_table (jmpthread_get_parent_name (threads[j]), frametable, j, 3);
    }
}

GtkWidget* get_frame (char* title, gint num, jmpthread** threads) {
    GtkWidget* frame = gtk_frame_new (title);
    GtkWidget* frametable = gtk_table_new (num, 4, FALSE);
    gtk_container_add (GTK_CONTAINER (frame), frametable);
    gtk_table_set_row_spacings (GTK_TABLE (frametable), 2);
    gtk_table_set_col_spacings (GTK_TABLE (frametable), 10);
    add_threads_to_frame (num, threads, frametable);
    return frame;
}


/** Add one monitor to the notebook.
 * @param monitor the monitor to add
 * @param notebook the notebook to add a tab to.
 */
static void add_monitor (void* monitor, void* notebook) {
    GtkWidget* label;
    GtkWidget* table;    
    GtkWidget* frame;
    int i = 0;
    monitor_info* mi = (monitor_info*)monitor;
    GtkWidget* tab = (GtkWidget*)notebook;

    gchar *labels[] = { _("Name"),
			_("Monitor id"),
			_("Owner"), 
			_("Entry count"), 
			NULL};
    
    char* ((*mp[])(monitor_info* m)) = { get_monitor_name,
					 get_monitor_id,
					 get_monitor_owner, 
					 get_monitor_entry_count,
					 NULL};
    table = get_table (labels, (tablefunc*)mp, mi);
    i = 4;
    frame = get_frame (_("Waiting to enter"), mi->num_waiting_to_enter, 
		       mi->waiting_to_enter);
    gtk_table_attach (GTK_TABLE (table), frame,  0, 2, i, i + 1, 
		      GTK_FILL, 0, 0, 0);
    i++;
    frame = get_frame (_("Waiting for notify"), mi->num_waiting_for_notify, 
		       mi->waiting_for_notify);
    gtk_table_attach (GTK_TABLE (table), frame,  0, 2, i, i + 1, 
		      GTK_FILL, 0, 0, 0);
    label = gtk_label_new (mi->name);
    gtk_notebook_append_page (GTK_NOTEBOOK (tab), table, label);
}

void show_monitor_dialog (hashtab* monitors) {
    GtkWidget* win;
    GtkWidget* tab;

    win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_object_set_data (GTK_OBJECT (win), "win", win);
    gtk_window_set_title (GTK_WINDOW (win), _("Monitor info"));
    tab = gtk_notebook_new ();
    gtk_notebook_popup_enable (GTK_NOTEBOOK (tab));
    gtk_notebook_set_scrollable (GTK_NOTEBOOK (tab), TRUE);
    gtk_container_add (GTK_CONTAINER (win), tab);
    
    jmphash_for_each_with_arg ((jmphash_iter_fa)add_monitor, monitors, tab);    
    
    gtk_widget_show_all (win);    
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
