#include <jmp-config.h>

#include <jmp.h>

#include <gtk/gtk.h>

#include <ui_gtk_method_window.h>
#include <ui_gtk_class_window.h>

/* Dialog for options */
static GtkWidget* dialog;

static gint delete_event (GtkWidget* widget, GdkEvent* event, 
			  gpointer data) {
    gtk_widget_hide (dialog);
    return TRUE;
}

/* Called when OK or Quit button of the options dialog is pressed */
static void event_close_dialog (GtkWidget *widget, gpointer data) {
    gtk_widget_hide (dialog);
}

static void set_visible_class_rows (GtkWidget *widget, gpointer data) {
    gint rows = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget));
    set_class_rows (rows);
}

static void set_visible_method_rows (GtkWidget *widget, gpointer data) {
    gint rows = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget));
    set_method_rows (rows);
}

void set_visible_rows (GtkObject* ignored) {
    if (dialog == NULL) {
	GtkWidget* spinner;
	GtkAdjustment* spinner_adj;
	GtkWidget* w;
	GtkWidget* buttonbox;
	GtkWidget *b = gtk_vbox_new (TRUE, 5);

	dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (dialog),
			      _("Java Memory Profiler - Visible rows"));
	gtk_signal_connect (GTK_OBJECT (dialog), "delete-event",
			    GTK_SIGNAL_FUNC (delete_event), NULL);
	gtk_container_add (GTK_CONTAINER (dialog), b);

	gtk_container_set_border_width (GTK_CONTAINER (dialog), 10);
	
	/* creates the spinner, with no decimal places */
	spinner_adj = (GtkAdjustment*)gtk_adjustment_new (get_class_rows (), 0.0, 10000.0, 100, 1000, 500);   
	spinner = gtk_spin_button_new (spinner_adj, 1.0, 0);
	gtk_signal_connect (GTK_OBJECT (spinner),"value-changed",
			    GTK_SIGNAL_FUNC (set_visible_class_rows),
			    (gpointer)TRUE);
	buttonbox = gtk_hbutton_box_new ();
	w = gtk_label_new (_("Class rows"));
	gtk_box_pack_start (GTK_BOX (buttonbox), w, TRUE, TRUE, 0);
	gtk_box_pack_end (GTK_BOX (buttonbox), spinner, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (b), buttonbox, TRUE, TRUE, 0);
	
	spinner_adj = (GtkAdjustment*)gtk_adjustment_new (get_method_rows (), 0.0, 10000.0, 100, 1000, 500);   
	spinner = gtk_spin_button_new (spinner_adj, 1.0, 0);
	gtk_signal_connect (GTK_OBJECT (spinner),"value-changed",
			    GTK_SIGNAL_FUNC (set_visible_method_rows),
			    (gpointer)TRUE);
	buttonbox = gtk_hbutton_box_new ();
	w = gtk_label_new (_("Method rows"));
	gtk_box_pack_start (GTK_BOX (buttonbox), w, TRUE, TRUE, 0);
	gtk_box_pack_end (GTK_BOX (buttonbox), spinner, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (b), buttonbox, TRUE, TRUE, 0);
	
	buttonbox = gtk_hbutton_box_new ();
	w = gtk_button_new_with_label (_("OK"));
	gtk_signal_connect (GTK_OBJECT (w),"clicked",
			    GTK_SIGNAL_FUNC (event_close_dialog),
			    (gpointer)TRUE);
	gtk_box_pack_start (GTK_BOX (buttonbox), w, FALSE,FALSE,0);
	gtk_box_pack_start (GTK_BOX (b), buttonbox, FALSE,FALSE,0);
    }
    gtk_widget_show_all (dialog);
}

void set_visible_rows_destroy () {
    if (dialog) {
	gtk_widget_hide (dialog);
	/* for some reason I get the
	 * "Xlib: unexpected async reply (sequence 0x1b44)!"
	 * if I destroy the dialog? /robo
	 */ 
	/*
	  gtk_widget_destroy (dialog);
	*/
    }
    dialog = NULL;
}
