/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Vector;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.eventdata.AbstractEventData;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.keyboard.KeyMapping;

public abstract class AbstractKeyEventData
extends AbstractEventData {
    private final Vector m_keyStrokes = new Vector();

    public final JFCKeyStroke[] getKeyStrokes() {
        return this.m_keyStrokes.toArray(new JFCKeyStroke[0]);
    }

    public final void setModifiers(int modifiers) {
        super.setModifiers(modifiers);
        this.setupKeyStrokes();
    }

    public int getDefaultModifiers() {
        return 0;
    }

    public static void setKeyMapping(KeyMapping km) {
        TestHelper.setKeyMapping(km);
    }

    public static KeyMapping getKeyMapping() {
        return TestHelper.getKeyMapping();
    }

    public final String getModifierText() {
        StringBuffer buf = new StringBuffer();
        int modifiers = this.getModifiers();
        if ((modifiers & 8) != 0) {
            buf.append(Toolkit.getProperty("AWT.alt", "Alt"));
            buf.append("+");
        }
        if ((modifiers & 4) != 0) {
            buf.append(Toolkit.getProperty("AWT.meta", "Meta"));
            buf.append("+");
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            buf.append("+");
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("AWT.shift", "Shift"));
            buf.append("+");
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
            buf.append("+");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public boolean canConsume(AWTEvent ae) {
        if (!this.isValid()) {
            return true;
        }
        return ae instanceof KeyEvent && this.getRoot((Component)ae.getSource()).equals(this.getRoot());
    }

    public boolean consume(AWTEvent ae) {
        if (!(ae instanceof KeyEvent)) {
            return false;
        }
        KeyEvent ke = (KeyEvent)ae;
        int id = ke.getID();
        return id == 400 || id == 402 || this.isMetaChar(ke.getKeyCode()) || ae.getSource().equals(this.getRoot());
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractKeyEventData data = (AbstractKeyEventData)o;
        Object[] dataStrokes = data.getKeyStrokes();
        Object[] thisStrokes = this.getKeyStrokes();
        return Arrays.equals(dataStrokes, thisStrokes);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean prepareComponent() {
        if (super.prepareComponent()) {
            if (!this.getComponent().hasFocus()) {
                this.getComponent().requestFocus();
                this.getTestCase().flushAWT();
            }
            return true;
        }
        return false;
    }

    protected abstract void setupKeyStrokes();

    protected final void addKeyStrokes(JFCKeyStroke[] strokes) {
        for (int i = 0; i < strokes.length; ++i) {
            this.m_keyStrokes.add(strokes[i]);
        }
    }

    protected final void applyModifier(int modifiers) {
        for (int i = 0; i < this.m_keyStrokes.size(); ++i) {
            JFCKeyStroke s = (JFCKeyStroke)this.m_keyStrokes.get(i);
            int mods = s.getModifiers() | modifiers;
            s.setModifiers(mods);
        }
    }

    protected final void clearKeyStrokes() {
        this.m_keyStrokes.clear();
    }
}

