/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import junit.extensions.jfcunit.eventdata.AbstractEventData;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.DragEventData;
import junit.extensions.jfcunit.eventdata.EventDataConstants;
import junit.extensions.jfcunit.eventdata.JFCEventDataListener;

public final class JFCEventManager
implements AWTEventListener,
EventDataConstants {
    public static final String EVENT_MAPPING_PROPERTY = "junit.extensions.jfcUnit.eventMapping";
    public static final String EVENT_DEBUG = "JFCEventManager.debug";
    private static JFCEventManager s_singleton;
    private static boolean s_debug;
    public static final int DEBUG_INPUT = 1;
    public static final int DEBUG_OUTPUT = 2;
    public static final int DEBUG_CREATE = 4;
    public static final int DEBUG_ALL = 7;
    private static int s_debugType;
    private AbstractEventData m_pendingEvent = null;
    private EventListenerList m_listenerList = new EventListenerList();
    private Thread m_timerThread;
    private boolean m_recording = false;
    private long m_holdTime;
    private volatile long m_lastEventTime = 0L;
    static /* synthetic */ Class class$junit$extensions$jfcunit$eventdata$JFCEventDataListener;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$AWTEvent;

    private JFCEventManager(long holdTime) {
        this.setHoldTime(holdTime);
    }

    public static void setDebug(boolean aValue) {
        s_debug = aValue;
        if (s_debug) {
            UIManager.put(EVENT_DEBUG, "true");
        } else {
            UIManager.put(EVENT_DEBUG, "false");
        }
    }

    public static boolean getDebug() {
        Boolean value = null;
        Object prop = UIManager.get(EVENT_DEBUG);
        if (prop instanceof Boolean) {
            value = (Boolean)prop;
        } else if (prop instanceof String) {
            value = Boolean.valueOf((String)prop);
        }
        s_debug = value == null ? false : value;
        return s_debug;
    }

    public static void setDebugType(int type) {
        s_debugType = type;
    }

    public static int getDebugType() {
        return s_debugType;
    }

    public static JFCEventManager getEventManager() {
        return JFCEventManager.getEventManager(100L);
    }

    public static JFCEventManager getEventManager(long holdTime) {
        if (s_singleton == null) {
            s_singleton = new JFCEventManager(holdTime);
        }
        return s_singleton;
    }

    public static void setRecording(boolean recording) {
        JFCEventManager.getEventManager().setRecordingImpl(recording);
    }

    public void setHoldTime(long holdTime) {
        this.m_holdTime = holdTime;
    }

    public long getHoldTime() {
        return this.m_holdTime;
    }

    public boolean getRecording() {
        return this.m_recording;
    }

    public void addJFCEventDataListener(JFCEventDataListener jl) {
        this.m_listenerList.add(class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? (class$junit$extensions$jfcunit$eventdata$JFCEventDataListener = JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener")) : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener, jl);
    }

    public boolean convertDrag(AWTEvent ae) {
        if (!(this.m_pendingEvent instanceof AbstractMouseEventData) || !(ae instanceof MouseEvent)) {
            return false;
        }
        MouseEvent me = (MouseEvent)ae;
        if (me.getID() != 506) {
            return false;
        }
        this.m_pendingEvent = new DragEventData(null, (AbstractMouseEventData)this.m_pendingEvent);
        return true;
    }

    public AbstractEventData createEvent(AWTEvent ae) {
        Object source = ae.getSource();
        ArrayList mapping = (ArrayList)UIManager.get(EVENT_MAPPING_PROPERTY);
        Iterator iter = mapping.iterator();
        while (iter.hasNext()) {
            String[] map = (String[])iter.next();
            Class<Object> target = null;
            try {
                target = !map[1].equals("*") ? Class.forName(map[1]) : (class$java$lang$Object == null ? JFCEventManager.class$("java.lang.Object") : class$java$lang$Object);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!target.isInstance(source)) continue;
            try {
                Class<?> cls;
                AbstractEventData data;
                if (s_debug && (s_debugType & 4) > 0) {
                    System.err.println("JFCEventManager.createEvent check class:" + map[0] + " can handle " + ae);
                }
                if (!(data = (AbstractEventData)(cls = Class.forName(map[0])).newInstance()).canConsume(ae)) continue;
                return data;
            }
            catch (Exception e) {
                System.err.println("Exception attempting to create instnce for:" + map[0]);
                e.printStackTrace();
            }
        }
        if (s_debug && (s_debugType & 4) > 0) {
            System.err.println("JFCEventManager.createEvent No EventData structure for:" + ae);
        }
        return null;
    }

    public void eventDispatched(AWTEvent ae) {
        this.processEventData(ae);
    }

    public void removeAllJFCEventDataListeners() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != (class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener") : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener)) continue;
            this.m_listenerList.remove(class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener") : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener, (EventListener)listeners[i + 1]);
        }
    }

    public void removeJFCEventDataListener(JFCEventDataListener jl) {
        this.m_listenerList.remove(class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? (class$junit$extensions$jfcunit$eventdata$JFCEventDataListener = JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener")) : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener, jl);
    }

    protected void fireEventData() {
        if (this.m_pendingEvent != null && this.m_pendingEvent.isValid()) {
            if (s_debug && (s_debugType & 2) > 0) {
                System.err.println("JFCEventManager.outputEvent:" + this.m_pendingEvent);
            }
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener") : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener)) continue;
                ((JFCEventDataListener)listeners[i + 1]).handleEvent(this.m_pendingEvent);
            }
        }
        this.m_pendingEvent = null;
    }

    protected synchronized void processEventData(AWTEvent ae) {
        if (s_debug && (s_debugType & 1) > 0) {
            System.err.println("JFCEventManager.inputEvent:" + ((InputEvent)ae).getWhen() + " " + ae);
        }
        this.m_lastEventTime = System.currentTimeMillis();
        if (ae instanceof MouseEvent && ((MouseEvent)ae).getID() == 503) {
            return;
        }
        if (this.m_pendingEvent != null && !this.m_pendingEvent.canConsume(ae) && !this.convertDrag(ae)) {
            this.fireEventData();
        }
        if (this.m_pendingEvent == null) {
            this.m_pendingEvent = this.createEvent(ae);
        }
        if (this.m_pendingEvent != null) {
            this.m_pendingEvent.consume(ae);
            this.m_lastEventTime = 0L;
        }
    }

    private void setRecordingImpl(boolean recording) {
        if (recording && !this.m_recording) {
            JFCEventManager.getDebug();
            long wheelMask = 0L;
            try {
                wheelMask = (class$java$awt$AWTEvent == null ? (class$java$awt$AWTEvent = JFCEventManager.class$("java.awt.AWTEvent")) : class$java$awt$AWTEvent).getField("MOUSE_WHEEL_EVENT_MASK").getLong(null);
            }
            catch (Exception e) {
                wheelMask = 0L;
            }
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 0x438L | wheelMask);
            this.m_timerThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (JFCEventManager.this.m_recording) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(JFCEventManager.this.m_holdTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        JFCEventManager jFCEventManager = JFCEventManager.this;
                        synchronized (jFCEventManager) {
                            long time = System.currentTimeMillis();
                            if (JFCEventManager.this.m_lastEventTime == 0L) {
                                JFCEventManager.this.m_lastEventTime = System.currentTimeMillis();
                            }
                            if (JFCEventManager.this.m_pendingEvent != null && time - JFCEventManager.this.m_lastEventTime > JFCEventManager.this.m_holdTime) {
                                JFCEventManager.this.fireEventData();
                            }
                        }
                    }
                    if (JFCEventManager.this.m_pendingEvent != null) {
                        JFCEventManager.this.fireEventData();
                    }
                }
            }, "JFCEventManager Timer");
            this.m_timerThread.start();
            this.m_recording = recording;
        } else if (!recording && this.m_recording) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.m_recording = recording;
            this.m_timerThread.interrupt();
        }
        this.m_recording = recording;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (UIManager.get(EVENT_MAPPING_PROPERTY) == null) {
            ArrayList<String[]> mapping = new ArrayList<String[]>();
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.JComboBoxMouseEventData", "javax.swing.JList"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.JListMouseEventData", "javax.swing.JList"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.JTableMouseEventData", "javax.swing.JTable"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.JTableHeaderMouseEventData", "javax.swing.table.JTableHeader"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.JTreeMouseEventData", "javax.swing.JTree"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.JTabbedPaneMouseEventData", "javax.swing.JTabbedPane"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.JTextComponentMouseEventData", "javax.swing.text.JTextComponent"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.MouseWheelEventData", "*"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.JMenuMouseEventData", "*"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.MouseEventData", "*"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.StringEventData", "*"});
            mapping.add(new String[]{"junit.extensions.jfcunit.eventdata.KeyEventData", "*"});
            UIManager.put(EVENT_MAPPING_PROPERTY, mapping);
        }
        s_singleton = null;
        s_debug = true;
        s_debugType = 7;
    }
}

