/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.type;

import org.fest.reflect.exception.ReflectionError;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeLoader {
    private final String typeName;
    private final ClassLoader classLoader;

    TypeLoader(String typeName, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("The given class loader should not be null");
        }
        this.typeName = typeName;
        this.classLoader = classLoader;
    }

    public Class<?> load() {
        try {
            return this.loadType();
        }
        catch (Exception e) {
            throw new ReflectionError(this.unableToLoadClassMessage(null), e);
        }
    }

    public <T> Class<? extends T> loadAs(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The given type should not be null");
        }
        try {
            return this.loadType().asSubclass(type);
        }
        catch (Exception e) {
            throw new ReflectionError(this.unableToLoadClassMessage(type), e);
        }
    }

    private String unableToLoadClassMessage(Class<?> asType) {
        StringBuilder msg = new StringBuilder();
        msg.append("Unable to load class ").append(Strings.quote((String)this.typeName));
        if (asType != null) {
            msg.append(" as ").append(asType.getName());
        }
        msg.append(" using class loader ").append(this.classLoader);
        return msg.toString();
    }

    private Class<?> loadType() throws ClassNotFoundException {
        return this.classLoader.loadClass(this.typeName);
    }
}

