/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongArrayAssert
extends ArrayAssert<long[]> {
    LongArrayAssert(long ... actual) {
        super(actual);
    }

    public LongArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public LongArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public LongArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    public LongArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public LongArrayAssert contains(long ... values) {
        this.isNotNull();
        this.assertContains(this.list(values));
        return this;
    }

    public LongArrayAssert containsOnly(long ... values) {
        this.isNotNull();
        this.assertContainsOnly(this.list(values));
        return this;
    }

    public LongArrayAssert excludes(long ... values) {
        this.isNotNull();
        this.assertExcludes(this.list(values));
        return this;
    }

    @Override
    List<Object> copyActual() {
        return this.list((long[])this.actual);
    }

    private List<Object> list(long[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (long value : values) {
            list.add(value);
        }
        return list;
    }

    public LongArrayAssert satisfies(Condition<long[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public LongArrayAssert doesNotSatisfy(Condition<long[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public LongArrayAssert isNotNull() {
        this.assertArrayNotNull();
        return this;
    }

    public LongArrayAssert isNotEmpty() {
        this.assertNotEmpty();
        return this;
    }

    public LongArrayAssert isEqualTo(long[] expected) {
        if (!Arrays.equals((long[])this.actual, expected)) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public LongArrayAssert isNotEqualTo(long[] array) {
        if (Arrays.equals((long[])this.actual, array)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, array));
        }
        return this;
    }

    public LongArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((long[])this.actual).length;
    }

    public LongArrayAssert isSameAs(long[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public LongArrayAssert isNotSameAs(long[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }
}

