/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.awt.AWT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJListCellReader;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListContentQuery;
import org.fest.swing.driver.JListItemValueQuery;
import org.fest.swing.driver.JListMatchingItemQuery;
import org.fest.swing.driver.JListScrollToItemTask;
import org.fest.swing.driver.JListSelectedIndexQuery;
import org.fest.swing.driver.JListSelectionValueQuery;
import org.fest.swing.driver.JListSelectionValuesQuery;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Range;
import org.fest.util.Arrays;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JListDriver
extends JComponentDriver {
    private static final String SELECTED_INDICES_PROPERTY = "selectedIndices";
    private static final String SELECTED_INDICES_LENGTH_PROPERTY = Strings.concat((Object[])new Object[]{"selectedIndices", "#length"});
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private JListCellReader cellReader;

    public JListDriver(Robot robot) {
        super(robot);
        this.cellReader(new BasicJListCellReader());
    }

    @RunsInEDT
    public String[] contentsOf(JList list) {
        return JListContentQuery.contents(list, this.cellReader);
    }

    public void selectItems(final JList list, final String[] values) {
        if (values == null) {
            throw new NullPointerException("Array of values should not be null");
        }
        if (Arrays.isEmpty((Object[])values)) {
            throw new IllegalArgumentException("Array of values should not be empty");
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return values.length;
            }

            void selectElement(int index) {
                JListDriver.this.selectItem(list, values[index]);
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void selectItem(JList list, String value) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, value, this.cellReader);
        this.robot.waitForIdle();
        this.verify(scrollInfo, value);
        if (scrollInfo.ii == null) {
            return;
        }
        this.robot.click((Component)list, this.cellCenterIn(scrollInfo));
    }

    public void clickItem(JList list, String value, MouseButton button, int times) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, value, this.cellReader);
        this.robot.waitForIdle();
        this.verify(scrollInfo, value);
        this.robot.click(list, this.cellCenterIn(scrollInfo), button, times);
    }

    public void selectItems(final JList list, final int[] indices) {
        if (indices == null) {
            throw new NullPointerException("The array of indices should not be null");
        }
        if (this.isEmptyArray(indices)) {
            throw new IllegalArgumentException("The array of indices should not be empty");
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return indices.length;
            }

            void selectElement(int index) {
                JListDriver.this.selectItem(list, indices[index]);
            }
        }.multiSelect();
    }

    private boolean isEmptyArray(int[] array) {
        return array == null || array.length == 0;
    }

    @RunsInEDT
    public void selectItems(JList list, Range.From from, Range.To to) {
        this.selectItems(list, from.value, to.value);
    }

    @RunsInEDT
    public void selectItems(JList list, int start, int end) {
        this.selectItem(list, start);
        this.robot.pressKey(16);
        this.clickItem(list, end, MouseButton.LEFT_BUTTON, 1);
        this.robot.releaseKey(16);
    }

    @RunsInEDT
    public void selectItem(JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, index);
        this.robot.waitForIdle();
        if (cellCenter == null) {
            return;
        }
        this.robot.click((Component)list, cellCenter);
    }

    @RunsInEDT
    public void clickItem(JList list, int index, MouseButton button, int times) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        this.robot.click(list, cellCenter, button, times);
    }

    @RunsInEDT
    public void requireSelection(JList list, String value) {
        Object selection = JListSelectionValueQuery.singleSelectionValue(list, this.cellReader);
        if (JListSelectionValueQuery.NO_SELECTION_VALUE == selection) {
            this.failNoSelection(list);
        }
        Assertions.assertThat((Object)selection).as(this.selectedIndexProperty(list)).isEqualTo((Object)value);
    }

    @RunsInEDT
    public void requireSelectedItems(JList list, String ... items) {
        if (items == null) {
            throw new NullPointerException("The array of items should not be null");
        }
        this.requireEqualSelection(list, items, this.selectionOf(list));
    }

    @RunsInEDT
    public String[] selectionOf(JList list) {
        return JListSelectionValuesQuery.selectionValues(list, this.cellReader);
    }

    private void requireEqualSelection(JList list, String[] expected, String[] actual) {
        int selectionCount = actual.length;
        if (selectionCount == 0) {
            this.failNoSelection(list);
        }
        Assertions.assertThat((int)selectionCount).as(JListDriver.propertyName(list, SELECTED_INDICES_LENGTH_PROPERTY)).isEqualTo(expected.length);
        for (int i = 0; i < selectionCount; ++i) {
            Description description = JListDriver.propertyName(list, Strings.concat((Object[])new Object[]{SELECTED_INDICES_PROPERTY, "[", String.valueOf(i), "]"}));
            Assertions.assertThat((String)actual[i]).as(description).isEqualTo(expected[i]);
        }
    }

    @RunsInEDT
    public void requireNoSelection(JList list) {
        Assertions.assertThat((int)JListSelectedIndexQuery.selectedIndexOf(list)).as(this.selectedIndexProperty(list)).isEqualTo(-1);
    }

    @RunsInEDT
    private void failNoSelection(JList list) {
        Fail.fail((String)Strings.concat((Object[])new Object[]{"[", this.selectedIndexProperty(list).value(), "] No selection"}));
    }

    @RunsInEDT
    private Description selectedIndexProperty(JList list) {
        return JListDriver.propertyName(list, SELECTED_INDEX_PROPERTY);
    }

    @RunsInEDT
    public void drag(JList list, String value) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, value, this.cellReader);
        this.robot.waitForIdle();
        this.verify(scrollInfo, value);
        super.drag(list, this.cellCenterIn(scrollInfo));
    }

    @RunsInEDT
    public void drop(JList list, String value) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, value, this.cellReader);
        this.robot.waitForIdle();
        this.verify(scrollInfo, value);
        super.drop(list, this.cellCenterIn(scrollInfo));
    }

    @RunsInEDT
    public void drag(JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drag(list, cellCenter);
    }

    @RunsInEDT
    public void drop(JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drop(list, cellCenter);
    }

    @RunsInEDT
    public void drop(JList list) {
        JListDriver.assertIsEnabledAndShowing(list);
        super.drop(list, AWT.visibleCenterOf(list));
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JList list, String value) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, value, this.cellReader);
        this.robot.waitForIdle();
        this.verify(scrollInfo, value);
        return this.robot.showPopupMenu(list, this.cellCenterIn(scrollInfo));
    }

    private void verify(Pair<Integer, Point> scrollInfo, String value) {
        if (JListScrollToItemTask.ITEM_NOT_FOUND.equals(scrollInfo)) {
            throw JListDriver.indexNotFoundFor(value);
        }
    }

    private Point cellCenterIn(Pair<Integer, Point> scrollInfo) {
        return (Point)scrollInfo.ii;
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        return this.robot.showPopupMenu(list, cellCenter);
    }

    @RunsInEDT
    public Point pointAt(JList list, String value) {
        return JListMatchingItemQuery.centerOfMatchingItemCell(list, value, this.cellReader);
    }

    @RunsInEDT
    public int indexOf(JList list, String value) {
        int index = JListDriver.itemIndex(list, value, this.cellReader);
        if (index >= 0) {
            return index;
        }
        throw JListDriver.indexNotFoundFor(value);
    }

    @RunsInEDT
    private static int itemIndex(final JList list, final String value, final JListCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                return JListMatchingItemQuery.matchingItemIndex(list, value, cellReader);
            }
        });
    }

    @RunsInEDT
    public String value(JList list, int index) {
        return JListItemValueQuery.itemValue(list, index, this.cellReader);
    }

    private static LocationUnavailableException indexNotFoundFor(String value) {
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find an element matching the value ", Strings.quote((String)value)}));
    }

    public void cellReader(JListCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.cellReader = newCellReader;
    }
}

