/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import javax.swing.JTable;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.data.TableCell;
import org.fest.swing.fixture.ColorFixture;
import org.fest.swing.fixture.FontFixture;
import org.fest.swing.fixture.ItemFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTableFixture;

public class JTableCellFixture
implements ItemFixture {
    private final JTableFixture table;
    private final TableCell cell;

    protected JTableCellFixture(JTableFixture table, TableCell cell) {
        if (table == null) {
            throw new NullPointerException("The JTableFixture should not be null");
        }
        if (cell == null) {
            throw new NullPointerException("The TableCell should not be null");
        }
        this.table = table;
        this.cell = cell;
    }

    JTableFixture table() {
        return this.table;
    }

    TableCell cell() {
        return this.cell;
    }

    public JTableCellFixture select() {
        this.table.selectCell(this.cell);
        return this;
    }

    public JTableCellFixture click() {
        this.table.click(this.cell, MouseButton.LEFT_BUTTON);
        return this;
    }

    public JTableCellFixture click(MouseClickInfo mouseClickInfo) {
        this.table.click(this.cell, mouseClickInfo);
        return this;
    }

    public JTableCellFixture doubleClick() {
        return this.click(MouseButton.LEFT_BUTTON, 2);
    }

    public JTableCellFixture rightClick() {
        return this.click(MouseButton.RIGHT_BUTTON);
    }

    public JTableCellFixture click(MouseButton button) {
        this.table.click(this.cell, button);
        return this;
    }

    private JTableCellFixture click(MouseButton button, int times) {
        this.table.click(this.cell, button, times);
        return this;
    }

    public JTableCellFixture startEditing() {
        this.table.driver().startCellEditing((JTable)this.table.target, this.cell);
        return this;
    }

    public JTableCellFixture stopEditing() {
        this.table.driver().stopCellEditing((JTable)this.table.target, this.cell);
        return this;
    }

    public JTableCellFixture cancelEditing() {
        this.table.driver().cancelCellEditing((JTable)this.table.target, this.cell);
        return this;
    }

    public Component editor() {
        return this.table.driver().cellEditor((JTable)this.table.target, this.cell);
    }

    public JTableCellFixture enterValue(String value) {
        this.table.driver().enterValueInCell((JTable)this.table.target, this.cell, value);
        return this;
    }

    public JTableCellFixture requireValue(String value) {
        this.table.requireCellValue(this.cell, value);
        return this;
    }

    public FontFixture font() {
        return this.table.fontAt(this.cell);
    }

    public ColorFixture background() {
        return this.table.backgroundAt(this.cell);
    }

    public ColorFixture foreground() {
        return this.table.foregroundAt(this.cell);
    }

    public String value() {
        return this.table.valueAt(this.cell);
    }

    public JTableCellFixture drag() {
        this.table.drag(this.cell);
        return this;
    }

    public JTableCellFixture drop() {
        this.table.drop(this.cell);
        return this;
    }

    public JPopupMenuFixture showPopupMenu() {
        return this.table.showPopupMenuAt(this.cell);
    }

    public JTableCellFixture requireEditable() {
        this.table.requireEditable(this.cell);
        return this;
    }

    public JTableCellFixture requireNotEditable() {
        this.table.requireNotEditable(this.cell);
        return this;
    }

    public int row() {
        return this.cell.row;
    }

    public int column() {
        return this.cell.column;
    }
}

