/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.image;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.FocusOwnerFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.image.ImageException;
import org.fest.swing.query.ComponentLocationOnScreenQuery;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.util.Files;
import org.fest.util.Strings;

public final class ScreenshotTaker {
    public static final String PNG_EXTENSION = "png";
    private final Robot robot;

    public ScreenshotTaker() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            throw new ImageException("Unable to create AWT Robot", e);
        }
    }

    public void saveDesktopAsPng(String imageFilePath) {
        this.saveImage(this.takeDesktopScreenshot(), imageFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage takeDesktopScreenshot() {
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        JTextComponent textComponent = ScreenshotTaker.findFocusOwnerAndHideItsCaret();
        try {
            BufferedImage bufferedImage = this.robot.createScreenCapture(screen);
            return bufferedImage;
        }
        finally {
            if (textComponent != null) {
                ScreenshotTaker.showCaretOf(textComponent);
            }
        }
    }

    public void saveComponentAsPng(Component c, String imageFilePath) {
        this.saveImage(this.takeScreenshotOf(c), imageFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage takeScreenshotOf(Component c) {
        Point locationOnScreen = ComponentLocationOnScreenQuery.locationOnScreen(c);
        Dimension size = ComponentSizeQuery.sizeOf(c);
        Rectangle r = new Rectangle(locationOnScreen.x, locationOnScreen.y, size.width, size.height);
        JTextComponent textComponent = ScreenshotTaker.findFocusOwnerAndHideItsCaret();
        if (textComponent != null) {
            this.robot.waitForIdle();
        }
        try {
            BufferedImage bufferedImage = this.robot.createScreenCapture(r);
            return bufferedImage;
        }
        finally {
            if (textComponent != null) {
                ScreenshotTaker.showCaretOf(textComponent);
                this.robot.waitForIdle();
            }
        }
    }

    @RunsInEDT
    private static JTextComponent findFocusOwnerAndHideItsCaret() {
        return GuiActionRunner.execute(new GuiQuery<JTextComponent>(){

            @Override
            protected JTextComponent executeInEDT() {
                Component focusOwner = FocusOwnerFinder.focusOwner();
                if (!(focusOwner instanceof JTextComponent)) {
                    return null;
                }
                JTextComponent textComponent = (JTextComponent)focusOwner;
                Caret caret = textComponent.getCaret();
                if (caret == null || !caret.isVisible()) {
                    return null;
                }
                caret.setVisible(false);
                return textComponent;
            }
        });
    }

    @RunsInEDT
    private static void showCaretOf(final JTextComponent textComponent) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                Caret caret = textComponent.getCaret();
                if (caret != null) {
                    caret.setVisible(true);
                }
            }
        });
    }

    public void saveImage(BufferedImage image, String filePath) {
        this.validate(filePath);
        try {
            ImageIO.write((RenderedImage)image, PNG_EXTENSION, Files.newFile((String)filePath));
        }
        catch (IOException e) {
            throw new ImageException(Strings.concat((Object[])new Object[]{"Unable to save image as ", Strings.quote((String)filePath)}), e);
        }
    }

    private void validate(String imageFilePath) {
        if (Strings.isEmpty((String)imageFilePath)) {
            throw new ImageException("The image path cannot be empty");
        }
        if (!imageFilePath.endsWith(PNG_EXTENSION)) {
            throw new ImageException(Strings.concat((Object[])new Object[]{"The image file should be a ", PNG_EXTENSION.toUpperCase(Locale.getDefault())}));
        }
    }
}

