/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fest.util.Strings;

public class Modifiers {
    private static final Map<Integer, Integer> MODIFIER_TO_KEY = new LinkedHashMap<Integer, Integer>();
    private static final Map<Integer, Integer> KEY_TO_MODIFIER = new LinkedHashMap<Integer, Integer>();

    public static int[] keysFor(int modifierMask) {
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        for (Integer mask : MODIFIER_TO_KEY.keySet()) {
            if ((modifierMask & mask) == 0) continue;
            keyList.add(MODIFIER_TO_KEY.get(mask));
        }
        int keyCount = keyList.size();
        int[] keys = new int[keyCount];
        for (int i = 0; i < keyCount; ++i) {
            keys[i] = (Integer)keyList.get(i);
        }
        return keys;
    }

    public static boolean isModifier(int keyCode) {
        return KEY_TO_MODIFIER.containsKey(keyCode);
    }

    public static int maskFor(int keyCode) {
        Integer key = keyCode;
        if (!KEY_TO_MODIFIER.containsKey(key)) {
            throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"Keycode '", String.valueOf(keyCode), "' is not a modifier"}));
        }
        return KEY_TO_MODIFIER.get(key);
    }

    public static int updateModifierWithKeyCode(int keyCode, int modifierMask) {
        int updatedModifierMask = modifierMask;
        for (Map.Entry<Integer, Integer> entry : MODIFIER_TO_KEY.entrySet()) {
            if (entry.getValue() != keyCode) continue;
            updatedModifierMask |= entry.getKey().intValue();
            break;
        }
        return updatedModifierMask;
    }

    static {
        MODIFIER_TO_KEY.put(32, 65406);
        KEY_TO_MODIFIER.put(65406, 32);
        MODIFIER_TO_KEY.put(8, 18);
        KEY_TO_MODIFIER.put(18, 8);
        MODIFIER_TO_KEY.put(1, 16);
        KEY_TO_MODIFIER.put(16, 1);
        MODIFIER_TO_KEY.put(2, 17);
        KEY_TO_MODIFIER.put(17, 2);
        MODIFIER_TO_KEY.put(4, 157);
        KEY_TO_MODIFIER.put(157, 4);
    }
}

