/* This file has been generated with opag 0.6.1.  */
/* This file is part of jpegpixi, a program to interpolate pixels in
   JFIF image files.
   Copyright (C) 2003, 2004 Martin Dickopp

   Jpegpixi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 2 of the License,
   or (at your option) any later version.

   Jpegpixi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with jpegpixi; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307,
   USA.  */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "util.h"

#include <stdio.h>


#if defined(__GLIBC__) && __GLIBC__ >= 2
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE 1
# endif
# include <getopt.h>
#endif

#ifndef STR_ERR_UNKNOWN_LONG_OPT
# define STR_ERR_UNKNOWN_LONG_OPT   "%s: unrecognized option `--%s'\n"
#endif

#ifndef STR_ERR_LONG_OPT_AMBIGUOUS
# define STR_ERR_LONG_OPT_AMBIGUOUS "%s: option `--%s' is ambiguous\n"
#endif

#ifndef STR_ERR_MISSING_ARG_LONG
# define STR_ERR_MISSING_ARG_LONG   "%s: option `--%s' requires an argument\n"
#endif

#ifndef STR_ERR_UNEXPEC_ARG_LONG
# define STR_ERR_UNEXPEC_ARG_LONG   "%s: option `--%s' doesn't allow an argument\n"
#endif

#ifndef STR_ERR_UNKNOWN_SHORT_OPT
# define STR_ERR_UNKNOWN_SHORT_OPT  "%s: unrecognized option `-%c'\n"
#endif

#ifndef STR_ERR_MISSING_ARG_SHORT
# define STR_ERR_MISSING_ARG_SHORT  "%s: option `-%c' requires an argument\n"
#endif

#define STR_HELP_THRESHOLD \
  "  -t, --threshold=THRESHOLD    specify threshold between noise and signal\n" \
  "                                 [default: 10%]\n"

#define STR_HELP_COMMENTS \
  "  -c, --comments               output comments with luminosities of hot pixel\n" \
  "                                 blocks\n"

#define STR_HELP_HELP \
  "      --help                   display this help text and exit\n"

#define STR_HELP_VERSION \
  "      --version                display version information and exit\n"

#define STR_HELP \
  STR_HELP_THRESHOLD \
  STR_HELP_COMMENTS \
  STR_HELP_HELP \
  STR_HELP_VERSION

/* Set to 1 if option --threshold (-t) has been specified.  */
char opt_threshold;

/* Set to 1 if option --comments (-c) has been specified.  */
char opt_comments;

/* Set to 1 if option --help has been specified.  */
char opt_help;

/* Set to 1 if option --version has been specified.  */
char opt_version;

/* Argument to option --threshold (-t).  */
const char *arg_threshold;

/* Parse command line options.  Return index of first non-option argument,
   or -1 if an error is encountered.  */
int parse_options (const char *const program_name, const int argc, char **const argv)
{
#if !defined(__GLIBC__) || __GLIBC__ < 2
  static const char *const optstr__threshold = "threshold";
  static const char *const optstr__comments = "comments";
  static const char *const optstr__help = "help";
  static const char *const optstr__version = "version";
  int i = 0;
#endif
  opt_threshold = 0;
  opt_comments = 0;
  opt_help = 0;
  opt_version = 0;
  arg_threshold = 0;
#if defined(__GLIBC__) && __GLIBC__ >= 2
  argv [0] = (char *)program_name;
  optind = 1;
  while (1)
  {
    static const struct option options [] = {
      {"comments", no_argument, 0, 'c'},
      {"threshold", required_argument, 0, 't'},
      {"help", no_argument, 0, 256},
      {"version", no_argument, 0, 257},
      {0, 0, 0, 0}};
    const int opt = getopt_long (argc, argv, "ct:", options, (int *)0);
    switch (opt)
    {
     case -1:
      return optind;
     case 'c':
      opt_comments = 1;
      break;
     case 't':
      opt_threshold = 1;
      arg_threshold = optarg;
      break;
     case 256:
      opt_help = 1;
      return optind;
     case 257:
      opt_version = 1;
      return optind;
     default:
      return -1;
    }
  }
#else
  while (++i < argc)
  {
    const char *option = argv [i];
    if (*option != '-')
      return i;
    else if (*++option == '\0')
      return i;
    else if (*option == '-')
    {
      const char *argument;
      size_t option_len;
      ++option;
      if ((argument = strchr (option, '=')) == option)
        goto error_unknown_long_opt;
      else if (argument == 0)
        option_len = strlen (option);
      else
        option_len = argument++ - option;
      switch (*option)
      {
       case '\0':
        return i + 1;
       case 'c':
        if (strncmp (option + 1, optstr__comments + 1, option_len - 1) == 0)
        {
          if (argument != 0)
          {
            option = optstr__comments;
            goto error_unexpec_arg_long;
          }
          opt_comments = 1;
          break;
        }
        goto error_unknown_long_opt;
       case 'h':
        if (strncmp (option + 1, optstr__help + 1, option_len - 1) == 0)
        {
          if (argument != 0)
          {
            option = optstr__help;
            goto error_unexpec_arg_long;
          }
          opt_help = 1;
          return i + 1;
        }
        goto error_unknown_long_opt;
       case 't':
        if (strncmp (option + 1, optstr__threshold + 1, option_len - 1) == 0)
        {
          if (argument != 0)
            arg_threshold = argument;
          else if (++i < argc)
            arg_threshold = argv [i];
          else
          {
            option = optstr__threshold;
            goto error_missing_arg_long;
          }
          opt_threshold = 1;
          break;
        }
        goto error_unknown_long_opt;
       case 'v':
        if (strncmp (option + 1, optstr__version + 1, option_len - 1) == 0)
        {
          if (argument != 0)
          {
            option = optstr__version;
            goto error_unexpec_arg_long;
          }
          opt_version = 1;
          return i + 1;
        }
       default:
       error_unknown_long_opt:
        fprintf (stderr, STR_ERR_UNKNOWN_LONG_OPT, program_name, option);
        return -1;
       error_missing_arg_long:
        fprintf (stderr, STR_ERR_MISSING_ARG_LONG, program_name, option);
        return -1;
       error_unexpec_arg_long:
        fprintf (stderr, STR_ERR_UNEXPEC_ARG_LONG, program_name, option);
        return -1;
      }
    }
    else
      do
      {
        switch (*option)
        {
         case 'c':
          opt_comments = 1;
          break;
         case 't':
          if (option [1] != '\0')
            arg_threshold = option + 1;
          else if (++i < argc)
            arg_threshold = argv [i];
          else
            goto error_missing_arg_short;
          option = "\0";
          opt_threshold = 1;
          break;
         default:
          fprintf (stderr, STR_ERR_UNKNOWN_SHORT_OPT, program_name, *option);
          return -1;
         error_missing_arg_short:
          fprintf (stderr, STR_ERR_MISSING_ARG_SHORT, program_name, *option);
          return -1;
        }
      } while (*++option != '\0');
  }
  return i;
#endif
}


/* Text to display in response to the --help command line option.  */
const char usage_text [] = "\
Usage: %s [OPTION]... JPEG-FILE [PIXEL-BLOCKS-FILE]\n\
Find hot pixels in an otherwise black JPEG image and write their coordinates\n\
to a pixel blocks file suitable for the jpegpixi program.\n\n\
Options:\n" STR_HELP "\n\
Please report bugs to <" PACKAGE_BUGREPORT ">.\n";

/* Text to display in response to the --version command line option.  */
const char version_text [] gcc_attr_section ((".license")) =
"jpeghotp (" PACKAGE_NAME ") " PACKAGE_VERSION "\n\
Copyright (C) 2003, 2004 Martin Dickopp\n\n\
This program is free software; it may be copied and/or modified under the\n\
terms of the GNU General Public License version 2 or (at your option) any\n\
later version. There is NO warranty; not even for MERCHANTABILITY or FIT-\n\
NESS FOR A PARTICULAR PURPOSE.\n";
