import _jpilot

def taskPromotion(self, records):
    return map(Todo, records)

def memoPromotion(self, records):
    return map(Memo, records)

def contactPromotion(self, records):
    return map(Contact, records)

def eventPromotion(self, records):
    return map(Event, records)

class Memo(_jpilot.Memo):
    pass

class Contact(_jpilot.Contact):
    pass

class Event(_jpilot.Event):
    pass

class Todo(_jpilot.Todo):
    _keys = ["advance","alarm_library","color",
             "icon_number","alarm","font","urgency",
             "custom_alarm","repeat_type",
             "repeat_end_date","repeat_frequency",
             "repeat_on","repeat_start_of_week",
             "links"]
    dbfield = []
    blankfield = "[00-99:99 sI@A.... OOOO@N@@@@ ]"
    
    def __init__(self, todo=None):
        _jpilot.Todo.__init__(self, todo)
        note = _jpilot.Todo.__getitem__(self, 'note')
        if len(note) >= 31 and note[0] == "[" and note[30] == "]":
            self.dbfield = list(note[0:31])

    def keys(self):
        return _jpilot.Todo.keys(self) + self._keys

    def _get_urgency(self):
        if self.dbfield and self.dbfield[29] in ('A','B','C','D'):
            return self.dbfield[29]
        return None

    def _set_urgency(self, urgency):
        if urgency is None:
            self.dbfield[29] = " "
        elif urgency.upper() in ('A','B','C','D'):
            self.dbfield[29] = urgency.upper()
        else:
            raise ValueError("Urgency must be A, B, C, D or None")

    def __getitem__(self, item):
        if item in self._keys:
            if hasattr(self, "_get_%s" % item):
                return getattr(self, "_get_%s" % item)()
            raise NotImplemented("Unable to get %s yet." % item)
        elif item == "note":
            note = _jpilot.Todo.__getitem__(self, item)
            if self.dbfield:
                return note[31:]
            else:
                return note
        else:
            return _jpilot.Todo.__getitem__(self, item)

    def __setitem__(self, item, value):
        if item in self._keys:
            if hasattr(self, "_set_%s" % item):
                if not self.dbfield:
                    self.dbfield = list(self.blankfield)
                    # write into the note, so that when the user
                    # fetches the note again and we start at the 31st
                    # byte, they get what they expect.
                    _jpilot.Todo.__setitem__(self, 'note', "".join(self.dbfield) +  _jpilot.Todo.__getitem__(self, 'note'))
                getattr(self, "_set_%s" % item)(value)
                # update the backing store
                _jpilot.Todo.__setitem__(self, 'note', "".join(self.dbfield) +  self['note'])
                return
            raise NotImplementedError("Unable to set %s yet." % item)
        if item == "note":
            value = "".join(self.dbfield) + value
        _jpilot.Todo.__setitem__(self, item, value)
