import vobject
import datetime

def event_to_vevent(event):
    cal = vobject.iCalendar()
    vevent = cal.add('vevent')
    
    vevent.add('summary').value    = event["description"]
    vevent.add('description').value= event["description"] # for calend on N800
    vevent.add('comment').value    = event["note"]
    vevent.add('dtstart').value    = event["begin"]
    vevent.add('dtend').value      = event["end"]
    vevent.add('uid').value        = "jppy-event-%s" % event.unique_id
#    vevent.add('categories').value = [calendar_categories[event.category]]
    vevent.add('dtstamp').value = datetime.datetime.now()
    if event.secret:
        vevent.add('class').value        = "PRIVATE"

    if event["alarm"]:
        alarm = vevent.add("valarm")
        alarm.add('action').value = "AUDIO"
        alarm.add('trigger').value = -1 * event["alarm"]
        
    vevent.rruleset = event["dates"]
    return vevent
