#!/usr/bin/python

import vobject
import vobject.base
import vobject.vcard
import mx.DateTime
import base64
import jppy
from PIL import Image
import cStringIO

# http://www.imc.org/pdi/vcard-21.txt
class VCard2_1(vobject.vcard.VCardBehavior):
    """vCard 2.1 behavior."""
    name = 'VCARD'
    description = 'vCard 2.1'
    versionString = '2.1'
    isComponent = True
    sortFirst = ('version', 'prodid', 'uid')
    knownChildren = {'N':         (1, 1, None),#min, max, behaviorRegistry id
                     'FN':        (1, 1, None),
                     'VERSION':   (1, 1, None),#required, auto-generated
                     'LABEL':     (0, None, None),
                     'UID':       (0, None, None),
                     'ADR':       (0, None, None),
                     'PHOTO':     (0, None, None),
                     'CATEGORIES':(0, None, None)
                    }
                    
    @classmethod
    def generateImplicitParameters(cls, obj):
        """Create PRODID, VERSION, and VTIMEZONEs if needed.
        
        VTIMEZONEs will need to exist whenever TZID parameters exist or when
        datetimes with tzinfo exist.
        
        """
        if not hasattr(obj, 'version'):
            obj.add(ContentLine('VERSION', [], cls.versionString))

vobject.base.registerBehavior(VCard2_1, default=True)

class vcardLoader(jppy.core.Component):
    def parse(self, stream):
        records = []
        for v in vobject.readComponents(stream):
            c = self.env.addressBook.new()
            c['lastname'] = v.n.value.family
            c['firstname'] = v.n.value.given
            if hasattr(v,'org'):
                c['company'] = v.org.value
            if hasattr(v,'title'):
                c['title'] = v.title.value
            if hasattr(v,'bday'):
                try:
                    c['birthday'] = mx.DateTime.strptime(v.bday.value,"%Y%m%d")
                except mx.DateTime.Error, e:
                    try:
                        c['birthday'] = mx.DateTime.strptime(v.bday.value,"%Y-%m-%d")
                    except mx.DateTime.Error, e:
                        # oh well
                        pass

            tel_map = {"CELL": 7,
                       "WORK": 0,
                       "HOME": 2,
                       "EMAIL": 4,
                       "FAX": 2}

            adr_map = {"WORK": 0,
                       "HOME": 1}

            phones = []
            if hasattr(v,'tel_list'):
                for tel in v.tel_list:
                    if hasattr(tel,'type_param'):
                        typ = tel_map.get(tel.type_param,3)
                    elif hasattr(tel,'singletonparams'):
                        typ = 3 # default
                        for param in tel.singletonparams:
                            if tel_map.has_key(param):
                                typ = tel_map[param]
                    else:
                        typ = 3
                    phones.append((tel.value.encode('ascii'),typ))
            if hasattr(v,'email_list'):
                for email in v.email_list:
                    phones.append((email.value.encode('ascii'),tel_map["EMAIL"]))
            for n in range(len(phones),7):
                phones.append(("",0))
            c['phones_with_labels'] = phones

            if hasattr(v,'note'):
                c['note'] = v.note.value

            im_map = {'AIM': 1,
                      'MSN': 2,
                      'Yahoo': 3,
                      'ICQ': 4,
                      'IM': 5}
            ims_chosen = []
            for im in im_map.keys():
                if hasattr(v,'x-%s_list' % im.lower()):
                    for imdetail in getattr(v,'x-%s_list' % im.lower()):
                        ims_chosen.append((im_map[im], imdetail.value))

            if len(ims_chosen) > 0:
                c['typeim1'], c['im1'] = ims_chosen[0]
            if len(ims_chosen) > 1:
                c['typeim2'], c['im2'] = ims_chosen[0]

            if hasattr(v,'photo'):
                fp = cStringIO.StringIO(v.photo.value)
                im = Image.open(fp)
                im.thumbnail((144,144), Image.ANTIALIAS)
                fp = cStringIO.StringIO()                
                im.save(fp, "jpeg")
                fp.seek(0)
                c['picture'] = fp.read()

            if hasattr(v,'adr_list'):
                for adr, n in zip(v.adr_list[0:3],range(1,4)):
                    if hasattr(adr,'type_param'):
                        c['typeaddr%d' % n] = adr_map.get(adr.type_param,2)
                    elif hasattr(adr,'singletonparams'):
                        c['typeaddr%d' % n] = 2 # default
                        for param in adr.singletonparams:
                            if adr_map.has_key(param):
                                c['typeaddr%d' % n] = adr_map[param]

                    c["address%d" % n] = vobject.vcard.Address.toString(adr.value.street)
                    c["city%d" % n] = vobject.vcard.Address.toString(adr.value.city)
                    c["state%d" % n] = vobject.vcard.Address.toString(adr.value.region)
                    c["zip%d" % n] = vobject.vcard.Address.toString(adr.value.code)
                    c["country%d" % n] = vobject.vcard.Address.toString(adr.value.country)

            for n in range(1,10):
                attr = "x-palm-custom%d" % n
                if hasattr(v,attr):
                    c['custom%d' % n] = getattr(v,attr).value

            records.append(c)
        return records

if __name__ == "__main__":
    jppyenv = jppy.environment.Environment()
    loader  = vcardLoader(jppyenv)
    for contact in loader.parse(open("/tmp/card.vcf")):
        print contact
        # we could now jppy.addressBook().save(contact)
        print contact.vcard()
