import sys
import unittest
import jppy
import string
import types
import baseclass

class jppyRecordTest(baseclass.baseTest):
    def setUp(self):
        baseclass.baseTest.setUp(self)
    
    def testCheckMethods(self):
        t = self.book.new()
        assert(hasattr(t,'archived'))
        assert(hasattr(t,'keys'))
        assert(hasattr(t,'items'))
        assert(hasattr(t,'values'))        

    def testSetCategory(self):
        t = self.book.new()
        for cat in [3,10,5,14,2,15,0,4]:
            assert len(self.book.records()) == 0
            t.category = cat
            assert cat == t.category
            t[t.keys()[0]] = "1234"
            self.book.save(t)
            assert len(self.book.records(search="1234")) == 1
            assert cat == self.book.records(search="1234")[0].category
            self.book.delete(t)
            assert len(self.book.records(search="1234")) == 0            
        def setCategory(t, v):
            t.category = v
        self.assertRaises(ValueError, setCategory, t, 20)

    def testKeysReturnsList(self):
        assert type(self.book.new().keys()) == types.ListType

    def testValuesReturnsList(self):
        assert type(self.book.new().values()) == types.ListType

    def testItemsReturnsListofTuples(self):
        items = self.book.new().items()
        assert type(items) == types.ListType
        pair = items[0]
        assert type(pair) == types.TupleType
        assert len(pair) == 2

    def testValuesReturnsValue(self):
        record = self.book.new()
        record[record.keys()[0]] = "My record"
        assert "My record" in record.values()

    def testSaving(self):
        record = self.book.new()
        assert record.unsaved_changes == 0
        record[record.keys()[0]] = "My record"
        assert record.unsaved_changes == 1
        self.book.save(record)
        assert len(self.book.fetch(record.unique_id)) == 1
        assert record.unsaved_changes == 0        

    def testSearching(self):
        record = self.book.new()
        record[record.keys()[0]] = "12345"
        self.book.save(record)
        record = self.book.new()
        record[record.keys()[0]] = "67890"
        self.book.save(record)
        assert len(self.book.records(search='123')) == 1

    def testUpdating(self):
        record = self.book.new()
        record[record.keys()[0]] = "12345"
        self.book.save(record)
        record[record.keys()[0]] = "67890"
        self.book.save(record)
        assert len(self.book.records()) == 1
        assert len(self.book.records(deleted=True)) == 2

    def testSizelimit(self):
        record = self.book.new()
        try:
            record[record.keys()[0]] = "1" * 65000
        except ValueError:
            return
        self.fail()

class todoBasicTest(jppyRecordTest):
    def __init__(self, method):
        jppyRecordTest.__init__(self, method)
        self.book = jppy.jpilot.legacy.taskList(self.env)

class memoBasicTest(jppyRecordTest):
    def __init__(self, method):
        jppyRecordTest.__init__(self, method)
        self.book = jppy.jpilot.legacy.memoList(self.env)

class contactBasicTest(jppyRecordTest):
    def __init__(self, method):
        jppyRecordTest.__init__(self, method)
        self.book = jppy.jpilot.modern.addressBook(self.env)

class calendarBasicTest(jppyRecordTest):
    def __init__(self, method):
        jppyRecordTest.__init__(self, method)
        self.book = jppy.jpilot.legacy.calendar(self.env)

def suite():
    suite = unittest.TestSuite((unittest.makeSuite(todoBasicTest),
                                unittest.makeSuite(memoBasicTest),
#                                unittest.makeSuite(calendarBasicTest),
                                unittest.makeSuite(contactBasicTest),))
    
    return suite
