#!/usr/bin/python

import jppy
from optparse import OptionParser
import os
import glob

parser = OptionParser()
parser.add_option("-d", "--directory",
                  dest="directory", metavar="DIRECTORY",
                  help="Export set to DIRECTORY")
parser.add_option("-v", "--verbose",
                  dest="verbose",action="store_true",
                  help="Be verbose")

(options, args) = parser.parse_args()
if options.directory is None:
    parser.error("-d is required")
if not os.path.exists(options.directory):
    parser.error("Unable to find %s" % options.directory)    

number_added_this_run = 0
unique_ids = set()
env = jppy.environment.Environment()
ab = env.addressBook
for record in ab.records():
    unique_ids.add(record.unique_id)
    filename = os.path.join(options.directory, "%s.vcf" % record.unique_id)
    try:
        old_vcard = open(filename, "r").read()
    except IOError, e:
        old_vcard = None
    new_vcard = record.vcard()
    if new_vcard != old_vcard:
        number_added_this_run = number_added_this_run + 1
        if options.verbose:
            print "Updating %s" % filename
        open(filename, "w").write(new_vcard)
    elif options.verbose:
        pass #    print "Keeping %s" % filename
    if number_added_this_run >= 1000:
        print "Too many changes for phone"
        break

for filename in glob.glob(os.path.join(options.directory,"*.vcf")):
    if int(os.path.basename(filename[:-4])) not in unique_ids:
        print "Removing %s" % filename
        os.unlink(filename)

# here is now we might sent them over to a phone

#print "syncml-obex-client -b mac 13 --identifier \"PC Suite\" --slow-sync text/x-vcard Contacts --wbxml ",
#for i in unique_ids:
#    print "--add text/x-vcard %s.vcf" % i,
