/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit;

import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebConversation;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;

public class TestContext {
    private WebClient client;
    private String user;
    private String passwd;
    private List cookies;
    private boolean hasAuth;
    private Locale locale = Locale.getDefault();
    private String encodingScheme = "ISO-8859-1";
    private String resourceBundleName;
    private String baseUrl = "http://localhost:8080";
    private String userAgent;
    private String proxyName;
    private int proxyPort = 80;

    public TestContext() {
        this.cookies = new ArrayList();
    }

    public void setAuthorization(String user, String passwd) {
        this.user = user;
        this.passwd = passwd;
        this.hasAuth = true;
    }

    public void addCookie(String name, String value) {
        this.cookies.add(new Cookie(name, value));
    }

    public boolean hasAuthorization() {
        return this.hasAuth;
    }

    public boolean hasCookies() {
        return this.cookies.size() > 0;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.passwd;
    }

    public List getCookies() {
        return this.cookies;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean hasUserAgent() {
        return this.userAgent != null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public String toEncodedString(String text) {
        try {
            return new String(text.getBytes(), this.encodingScheme);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return text;
        }
    }

    public void setResourceBundleName(String name) {
        this.resourceBundleName = name;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean hasProxy() {
        return this.proxyName != null && this.proxyName.trim().length() > 0;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String url) {
        this.baseUrl = url.endsWith("/") ? url : url + "/";
    }

    public void setWebClient(WebClient client) {
        this.client = client;
    }

    public WebClient getWebClient() {
        if (this.client == null) {
            this.client = new WebConversation();
        }
        if (this.hasAuthorization()) {
            this.client.setAuthorization(this.getUser(), this.getPassword());
        }
        if (this.hasProxy()) {
            this.client.setProxyServer(this.getProxyName(), this.getProxyPort());
        }
        if (this.hasCookies()) {
            List cookies = this.getCookies();
            Iterator iter = cookies.iterator();
            while (iter.hasNext()) {
                Cookie c = (Cookie)iter.next();
                this.client.addCookie(c.getName(), c.getValue());
            }
        }
        if (this.hasUserAgent()) {
            ClientProperties properties = this.client.getClientProperties();
            properties.setUserAgent(this.getUserAgent());
        }
        return this.client;
    }
}

