/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit;

import java.io.PrintStream;
import java.util.Locale;
import java.util.ResourceBundle;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import net.sourceforge.jwebunit.ExpectedTable;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.TestContext;
import net.sourceforge.jwebunit.UnableToSetFormException;
import net.sourceforge.jwebunit.util.ExceptionUtility;
import org.w3c.dom.Element;

public class WebTester {
    private HttpUnitDialog dialog;
    private TestContext context = new TestContext();

    public HttpUnitDialog getDialog() {
        return this.dialog;
    }

    public TestContext getTestContext() {
        return this.context;
    }

    public void beginAt(String relativeURL) {
        String url = this.createUrl(relativeURL);
        this.dialog = new HttpUnitDialog(url, this.context);
    }

    private String createUrl(String suffix) {
        suffix = suffix.startsWith("/") ? suffix.substring(1) : suffix;
        return this.getTestContext().getBaseUrl() + suffix;
    }

    public String getMessage(String key) {
        String message = "";
        Locale locale = this.context.getLocale();
        try {
            message = ResourceBundle.getBundle(this.getTestContext().getResourceBundleName(), locale).getString(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("No message found for key [" + key + "]." + "\nError: " + ExceptionUtility.stackTraceToString(e));
        }
        return this.context.toEncodedString(message);
    }

    public void assertTitleEquals(String title) {
        Assert.assertEquals((String)title, (String)this.dialog.getResponsePageTitle());
    }

    public void assertTitleEqualsKey(String titleKey) {
        Assert.assertEquals((String)this.getMessage(titleKey), (String)this.dialog.getResponsePageTitle());
    }

    public void assertKeyPresent(String key) {
        this.assertTextPresent(this.getMessage(key));
    }

    public void assertTextPresent(String text) {
        if (!this.dialog.isTextInResponse(text)) {
            Assert.fail((String)("Expected text not found in response: [" + text + "]"));
        }
    }

    public void assertKeyNotPresent(String key) {
        this.assertTextNotPresent(this.getMessage(key));
    }

    public void assertTextNotPresent(String text) {
        if (this.dialog.isTextInResponse(text)) {
            Assert.fail((String)("Text found in response when not expected: [" + text + "]"));
        }
    }

    public void assertTablePresent(String tableSummaryOrId) {
        if (this.dialog.getWebTableBySummaryOrId(tableSummaryOrId) == null) {
            Assert.fail((String)("Unable to locate table \"" + tableSummaryOrId + "\""));
        }
    }

    public void assertTableNotPresent(String tableSummaryOrId) {
        if (this.dialog.getWebTableBySummaryOrId(tableSummaryOrId) != null) {
            Assert.fail((String)("Located table \"" + tableSummaryOrId + "\""));
        }
    }

    public void assertKeyInTable(String tableSummaryOrId, String key) {
        this.assertTextInTable(tableSummaryOrId, this.getMessage(key));
    }

    public void assertTextInTable(String tableSummaryOrId, String text) {
        this.assertTablePresent(tableSummaryOrId);
        Assert.assertTrue((String)("Could not find: [" + text + "]" + "in table [" + tableSummaryOrId + "]"), (boolean)this.dialog.isTextInTable(tableSummaryOrId, text));
    }

    public void assertKeysInTable(String tableSummaryOrId, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            this.assertKeyInTable(tableSummaryOrId, keys[i]);
        }
    }

    public void assertTextInTable(String tableSummaryOrId, String[] text) {
        for (int i = 0; i < text.length; ++i) {
            this.assertTextInTable(tableSummaryOrId, text[i]);
        }
    }

    public void assertKeyNotInTable(String tableSummaryOrId, String key) {
        this.assertTextNotInTable(tableSummaryOrId, this.getMessage(key));
    }

    public void assertTextNotInTable(String tableSummaryOrId, String text) {
        this.assertTablePresent(tableSummaryOrId);
        Assert.assertTrue((String)("Found text: [" + text + "] in table [" + tableSummaryOrId + "]"), (!this.dialog.isTextInTable(tableSummaryOrId, text) ? 1 : 0) != 0);
    }

    public void assertTextNotInTable(String tableSummaryOrId, String[] text) {
        for (int i = 0; i < text.length; ++i) {
            this.assertTextNotInTable(tableSummaryOrId, text[i]);
        }
    }

    public void assertTableEquals(String tableSummaryOrId, ExpectedTable expectedTable) {
        this.assertTableEquals(tableSummaryOrId, expectedTable.getExpectedStrings());
    }

    public void assertTableEquals(String tableSummaryOrId, String[][] expectedCellValues) {
        this.assertTableRowsEqual(tableSummaryOrId, 0, expectedCellValues);
    }

    public void assertTableRowsEqual(String tableSummaryOrId, int startRow, ExpectedTable expectedTable) {
        this.assertTableRowsEqual(tableSummaryOrId, startRow, expectedTable.getExpectedStrings());
    }

    public void assertTableRowsEqual(String tableSummaryOrId, int startRow, String[][] expectedCellValues) {
        this.assertTablePresent(tableSummaryOrId);
        String[][] sparseTableCellValues = this.dialog.getSparseTableBySummaryOrId(tableSummaryOrId);
        if (expectedCellValues.length > sparseTableCellValues.length - startRow) {
            Assert.fail((String)("Expected rows [" + expectedCellValues.length + "] larger than actual rows in range being compared" + " [" + (sparseTableCellValues.length - startRow) + "]."));
        }
        for (int i = 0; i < expectedCellValues.length; ++i) {
            String[] row = expectedCellValues[i];
            for (int j = 0; j < row.length; ++j) {
                if (row.length != sparseTableCellValues[i].length) {
                    Assert.fail((String)("Unequal number of columns for row " + i + " of table " + tableSummaryOrId + ". Expected [" + row.length + "] found [" + sparseTableCellValues[i].length + "]."));
                }
                String expectedString = row[j];
                Assert.assertEquals((String)("Expected " + tableSummaryOrId + " value at [" + i + "," + j + "] not found."), (String)expectedString, (String)this.context.toEncodedString(sparseTableCellValues[i + startRow][j].trim()));
            }
        }
    }

    public void assertFormElementPresent(String formElementName) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Did not find form element with name [" + formElementName + "]."), (boolean)this.dialog.hasFormParameterNamed(formElementName));
    }

    public void assertFormElementNotPresent(String formElementName) {
        this.assertFormPresent();
        try {
            Assert.assertTrue((String)("Found form element with name [" + formElementName + "] when not expected."), (!this.dialog.hasFormParameterNamed(formElementName) ? 1 : 0) != 0);
        }
        catch (UnableToSetFormException unableToSetFormException) {
            // empty catch block
        }
    }

    public void assertFormElementPresentWithLabel(String formElementLabel) {
        Assert.assertTrue((String)("Did not find form element with label [" + formElementLabel + "]."), (boolean)this.dialog.hasFormParameterLabeled(formElementLabel));
    }

    public void assertFormElementNotPresentWithLabel(String formElementLabel) {
        Assert.assertFalse((String)("Found form element with label [" + formElementLabel + "]."), (boolean)this.dialog.hasFormParameterLabeled(formElementLabel));
    }

    public void assertFormPresent() {
        Assert.assertTrue((String)"No form present", (boolean)this.dialog.hasForm());
    }

    public void assertFormPresent(String nameOrID) {
        Assert.assertTrue((String)("No form present with name or id [" + nameOrID + "]"), (boolean)this.dialog.hasForm(nameOrID));
    }

    public void assertFormNotPresent() {
        Assert.assertFalse((String)"A form is present", (boolean)this.dialog.hasForm());
    }

    public void assertFormNotPresent(String nameOrID) {
        Assert.assertFalse((String)("Form present with name or id [" + nameOrID + "]"), (boolean)this.dialog.hasForm(nameOrID));
    }

    public void assertFormElementEquals(String formElementName, String expectedValue) {
        this.assertFormElementPresent(formElementName);
        Assert.assertEquals((String)expectedValue, (String)this.dialog.getFormParameterValue(formElementName));
    }

    public void assertFormElementEmpty(String formElementName) {
        this.assertFormElementPresent(formElementName);
        Assert.assertEquals((String)"", (String)this.dialog.getFormParameterValue(formElementName));
    }

    public void assertCheckboxSelected(String checkBoxName) {
        this.assertFormElementPresent(checkBoxName);
        Assert.assertEquals((String)"on", (String)this.dialog.getFormParameterValue(checkBoxName));
    }

    public void assertCheckboxNotSelected(String checkBoxName) {
        this.assertFormElementPresent(checkBoxName);
        Assert.assertNull((Object)this.dialog.getFormParameterValue(checkBoxName));
    }

    public void assertRadioOptionPresent(String name, String radioOption) {
        this.assertFormElementPresent(name);
        if (!this.dialog.hasRadioOption(name, radioOption)) {
            Assert.fail((String)("Unable to find option " + radioOption + " in radio group " + name));
        }
    }

    public void assertRadioOptionNotPresent(String name, String radioOption) {
        this.assertFormElementPresent(name);
        if (this.dialog.hasRadioOption(name, radioOption)) {
            Assert.fail((String)("Found option " + radioOption + " in radio group " + name));
        }
    }

    public void assertRadioOptionSelected(String name, String radioOption) {
        this.assertFormElementPresent(name);
        this.assertFormElementEquals(name, radioOption);
    }

    public void assertRadioOptionNotSelected(String name, String radioOption) {
        this.assertFormElementPresent(name);
        Assert.assertTrue((String)("Radio option " + radioOption + " is not selected"), (!radioOption.equals(this.dialog.getFormParameterValue(name)) ? 1 : 0) != 0);
    }

    public void assertOptionsEqual(String selectName, String[] expectedOptions) {
        this.assertFormElementPresent(selectName);
        this.assertArraysEqual(expectedOptions, this.dialog.getOptionsFor(selectName));
    }

    public void assertOptionsNotEqual(String selectName, String[] expectedOptions) {
        this.assertFormElementPresent(selectName);
        try {
            this.assertOptionsEqual(selectName, expectedOptions);
        }
        catch (AssertionFailedError e) {
            return;
        }
        Assert.fail((String)"Options not expected to be equal");
    }

    public void assertOptionValuesEqual(String selectName, String[] expectedValues) {
        this.assertFormElementPresent(selectName);
        this.assertArraysEqual(expectedValues, this.dialog.getOptionValuesFor(selectName));
    }

    private void assertArraysEqual(String[] exptected, String[] returned) {
        Assert.assertEquals((String)"Arrays not same length", (int)exptected.length, (int)returned.length);
        for (int i = 0; i < returned.length; ++i) {
            Assert.assertEquals((String)("Elements " + i + "not equal"), (String)exptected[i], (String)returned[i]);
        }
    }

    public void assertOptionValuesNotEqual(String selectName, String[] optionValues) {
        this.assertFormElementPresent(selectName);
        try {
            this.assertOptionValuesEqual(selectName, optionValues);
        }
        catch (AssertionFailedError e) {
            return;
        }
        Assert.fail((String)"Values not expected to be equal");
    }

    public void assertOptionEquals(String selectName, String option) {
        this.assertFormElementPresent(selectName);
        Assert.assertEquals((String)option, (String)this.dialog.getSelectedOption(selectName));
    }

    public void assertSubmitButtonPresent(String buttonName) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Submit Button [" + buttonName + "] not found."), (boolean)this.dialog.hasSubmitButton(buttonName));
    }

    public void assertSubmitButtonNotPresent(String buttonName) {
        this.assertFormPresent();
        Assert.assertFalse((String)("Submit Button [" + buttonName + "] found."), (boolean)this.dialog.hasSubmitButton(buttonName));
    }

    public void assertSubmitButtonValue(String buttonName, String expectedValue) {
        this.assertFormPresent();
        this.assertSubmitButtonPresent(buttonName);
        Assert.assertEquals((String)expectedValue, (String)this.dialog.getSubmitButtonValue(buttonName));
    }

    public void assertButtonPresent(String buttonId) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Button [" + buttonId + "] not found."), (boolean)this.dialog.hasButton(buttonId));
    }

    public void assertButtonNotPresent(String buttonId) {
        this.assertFormPresent();
        Assert.assertFalse((String)("Button [" + buttonId + "] found."), (boolean)this.dialog.hasButton(buttonId));
    }

    public void assertLinkPresent(String linkId) {
        Assert.assertTrue((String)("Unable to find link with id [" + linkId + "]"), (boolean)this.dialog.isLinkPresent(linkId));
    }

    public void assertLinkNotPresent(String linkId) {
        Assert.assertTrue((String)("link with id [" + linkId + "] found in response"), (!this.dialog.isLinkPresent(linkId) ? 1 : 0) != 0);
    }

    public void assertLinkPresentWithText(String linkText) {
        Assert.assertTrue((String)("Link with text [" + linkText + "] not found in response."), (boolean)this.dialog.isLinkPresentWithText(linkText));
    }

    public void assertLinkNotPresentWithText(String linkText) {
        Assert.assertTrue((String)("Link with text [" + linkText + "] found in response."), (!this.dialog.isLinkPresentWithText(linkText) ? 1 : 0) != 0);
    }

    public void assertLinkPresentWithText(String linkText, int index) {
        Assert.assertTrue((String)("Link with text [" + linkText + "] and index " + index + " not found in response."), (boolean)this.dialog.isLinkPresentWithText(linkText, index));
    }

    public void assertLinkNotPresentWithText(String linkText, int index) {
        Assert.assertTrue((String)("Link with text [" + linkText + "] and index " + index + " found in response."), (!this.dialog.isLinkPresentWithText(linkText, index) ? 1 : 0) != 0);
    }

    public void assertLinkPresentWithImage(String imageFileName) {
        Assert.assertTrue((String)("Link with image file [" + imageFileName + "] not found in response."), (boolean)this.dialog.isLinkPresentWithImage(imageFileName));
    }

    public void assertLinkNotPresentWithImage(String imageFileName) {
        Assert.assertTrue((String)("Link with image file [" + imageFileName + "] found in response."), (!this.dialog.isLinkPresentWithImage(imageFileName) ? 1 : 0) != 0);
    }

    public void assertElementPresent(String anID) {
        Assert.assertNotNull((String)("Unable to locate element with id \"" + anID + "\""), (Object)this.dialog.getElement(anID));
    }

    public void assertElementNotPresent(String anID) {
        Assert.assertNull((String)("Located element with id \"" + anID + "\""), (Object)this.dialog.getElement(anID));
    }

    public void assertTextInElement(String elementID, String text) {
        Element element = this.dialog.getElement(elementID);
        Assert.assertNotNull((String)("Unable to locate element with id \"" + elementID + "\""), (Object)element);
        Assert.assertTrue((String)("Unable to locate [" + text + "] in element \"" + elementID + "\""), (boolean)this.dialog.isTextInElement(element, text));
    }

    public void assertTextNotInElement(String elementID, String text) {
        this.assertElementPresent(elementID);
        Element element = this.dialog.getElement(elementID);
        Assert.assertNotNull((String)("Unable to locate element with id \"" + elementID + "\""), (Object)element);
        Assert.assertFalse((String)("Text [" + text + "] found in element [" + elementID + "] when not expected"), (boolean)this.dialog.isTextInElement(element, text));
    }

    public void assertWindowPresent(String windowName) {
        Assert.assertNotNull((String)("Unable to locate window [" + windowName + "]."), (Object)this.dialog.getWindow(windowName));
    }

    public void assertFramePresent(String frameName) {
        Assert.assertNotNull((String)("Unable to locate frame [" + frameName + "]."), (Object)this.dialog.getFrame(frameName));
    }

    public void assertCookiePresent(String cookieName) {
        Assert.assertTrue((String)("Could not find Cookie : [" + cookieName + "]"), (boolean)this.dialog.hasCookie(cookieName));
    }

    public void assertCookieValueEquals(String cookieName, String expectedValue) {
        this.assertCookiePresent(cookieName);
        Assert.assertEquals((String)expectedValue, (String)this.dialog.getCookieValue(cookieName));
    }

    public void dumpCookies() {
        this.dumpCookies(System.out);
    }

    public void dumpCookies(PrintStream stream) {
        this.dialog.dumpCookies(stream);
    }

    public void setWorkingForm(String nameOrId) {
        this.dialog.setWorkingForm(nameOrId);
    }

    public void setFormElement(String formElementName, String value) {
        this.assertFormPresent();
        this.assertFormElementPresent(formElementName);
        this.dialog.setFormParameter(formElementName, value);
    }

    protected void setFormElementWithLabel(String formElementLabel, String value) {
        String name = this.dialog.getFormElementNameForLabel(formElementLabel);
        Assert.assertNotNull((String)("Did not find form element with label [" + formElementLabel + "]."), (Object)name);
        this.dialog.setFormParameter(name, value);
    }

    public void checkCheckbox(String checkBoxName) {
        this.assertFormElementPresent(checkBoxName);
        this.dialog.setFormParameter(checkBoxName, "on");
    }

    public void checkCheckbox(String checkBoxName, String value) {
        this.assertFormElementPresent(checkBoxName);
        this.dialog.updateFormParameter(checkBoxName, value);
    }

    public void uncheckCheckbox(String checkBoxName) {
        this.assertFormElementPresent(checkBoxName);
        this.dialog.removeFormParameter(checkBoxName);
    }

    public void uncheckCheckbox(String checkBoxName, String value) {
        this.assertFormElementPresent(checkBoxName);
        this.dialog.removeFormParameterWithValue(checkBoxName, value);
    }

    public void selectOption(String selectName, String option) {
        this.assertFormElementPresent(selectName);
        this.dialog.selectOption(selectName, option);
    }

    public void submit() {
        this.assertFormPresent();
        this.dialog.submit();
    }

    public void submit(String buttonName) {
        this.assertSubmitButtonPresent(buttonName);
        this.dialog.submit(buttonName);
    }

    public void reset() {
        this.dialog.reset();
    }

    public void clickLinkWithText(String linkText) {
        this.assertLinkPresentWithText(linkText);
        this.dialog.clickLinkWithText(linkText);
    }

    public void clickLinkWithText(String linkText, int index) {
        this.assertLinkPresentWithText(linkText, index);
        this.dialog.clickLinkWithText(linkText, index);
    }

    public void clickLinkWithTextAfterText(String linkText, String labelText) {
        this.dialog.clickLinkWithTextAfterText(linkText, labelText);
    }

    public void clickButton(String buttonId) {
        this.assertButtonPresent(buttonId);
        this.dialog.clickButton(buttonId);
    }

    public void clickLinkWithImage(String imageFileName) {
        this.assertLinkPresentWithImage(imageFileName);
        this.dialog.clickLinkWithImage(imageFileName);
    }

    public void clickLink(String linkId) {
        this.assertLinkPresent(linkId);
        this.dialog.clickLink(linkId);
    }

    public void gotoWindow(String windowName) {
        this.assertWindowPresent(windowName);
        this.dialog.gotoWindow(windowName);
    }

    public void gotoRootWindow() {
        this.dialog.gotoRootWindow();
    }

    public void gotoFrame(String frameName) {
        this.dialog.gotoFrame(frameName);
    }

    public void gotoPage(String url) {
        this.dialog.gotoPage(this.createUrl(url));
    }

    public void dumpResponse() {
        this.dialog.dumpResponse();
    }

    public void dumpResponse(PrintStream stream) {
        this.dialog.dumpResponse(stream);
    }

    public void dumpTable(String tableNameOrId, PrintStream stream) {
        this.dialog.dumpTable(tableNameOrId, stream);
    }

    public void dumpTable(String tableNameOrId, String[][] table) {
        this.dialog.dumpTable(tableNameOrId, table);
    }

    public void dumpTable(String tableNameOrId, String[][] table, PrintStream stream) {
        this.dialog.dumpTable(tableNameOrId, table, stream);
    }
}

