/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.WeightedTerm;

public final class QueryTermExtractor {
    public static final WeightedTerm[] getTerms(Query query) {
        return QueryTermExtractor.getTerms(query, false);
    }

    public static final WeightedTerm[] getIdfWeightedTerms(Query query, IndexReader reader, String fieldName) {
        WeightedTerm[] terms = QueryTermExtractor.getTerms(query, false, fieldName);
        int totalNumDocs = reader.numDocs();
        for (int i = 0; i < terms.length; ++i) {
            try {
                int docFreq = reader.docFreq(new Term(fieldName, terms[i].term));
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                terms[i].weight *= idf;
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return terms;
    }

    public static final WeightedTerm[] getTerms(Query query, boolean prohibited, String fieldName) {
        HashSet terms = new HashSet();
        if (fieldName != null) {
            fieldName = fieldName.intern();
        }
        QueryTermExtractor.getTerms(query, terms, prohibited, fieldName);
        return terms.toArray(new WeightedTerm[0]);
    }

    public static final WeightedTerm[] getTerms(Query query, boolean prohibited) {
        return QueryTermExtractor.getTerms(query, prohibited, null);
    }

    private static final void getTerms(Query query, HashSet terms, boolean prohibited, String fieldName) {
        try {
            HashSet nonWeightedTerms = new HashSet();
            query.extractTerms(nonWeightedTerms);
            Iterator iter = nonWeightedTerms.iterator();
            while (iter.hasNext()) {
                Term term = (Term)iter.next();
                if (fieldName != null && term.field() != fieldName) continue;
                terms.add(new WeightedTerm(query.getBoost(), term.text()));
            }
        }
        catch (UnsupportedOperationException ignore) {
            // empty catch block
        }
    }
}

