/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.wikiwizard.CopyAndPastePopup;
import org.wikiwizard.WikiWizardApplet;
import org.wikiwizard.observeModul;

public class MailToDialog
extends JDialog
implements KeyListener,
FocusListener,
ActionListener,
MouseListener {
    private observeModul obsable;
    private JTextField name;
    private JTextField mail;
    private JButton insertButton;
    private JButton cancelButton;
    private JApplet owner;
    private String lab;
    private WikiWizardApplet wiki;
    private ResourceBundle bundle = null;
    private boolean replace;
    private boolean table;
    Font menuFontSize = new Font("Dialog", 0, 12);
    private CopyAndPastePopup popupMenu = new CopyAndPastePopup();

    public MailToDialog(JDialog d, boolean table, Object obs, String labelText, String mailText, boolean replace) {
        super((Dialog)d, true);
        this.init(table, obs, labelText, mailText, replace, false);
    }

    public MailToDialog(JApplet d, boolean table, Object obs, String labelText, String mailText, boolean replace, boolean newItem) {
        super(JOptionPane.getFrameForComponent(d), true);
        this.init(table, obs, labelText, mailText, replace, newItem);
    }

    public void init(boolean table, Object obs, String labelText, String mailText, boolean replace, boolean newItem) {
        if (newItem && labelText.equals("") && mailText.indexOf("@") < 0) {
            labelText = mailText;
            mailText = "";
        }
        this.table = table;
        this.replace = replace;
        this.bundle = ResourceBundle.getBundle(WikiWizardApplet.resource_lang + ".ProgramStrings", WikiWizardApplet.locale);
        this.lab = labelText;
        this.wiki = (WikiWizardApplet)obs;
        this.owner = (JApplet)obs;
        this.setModal(true);
        this.setLocationRelativeTo(this.owner);
        this.setTitle(this.bundle.getString("mailToDialogTitle"));
        this.obsable = new observeModul();
        this.obsable.addObserver((Observer)obs);
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        JLabel label = new JLabel("  " + this.bundle.getString("EMailAdress") + " ");
        label.setFont(this.menuFontSize);
        pane.add((Component)label, c);
        this.mail = new JTextField(mailText, 20){

            public boolean isManagingFocus() {
                return true;
            }
        };
        this.mail.addFocusListener(this);
        this.mail.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9 && MailToDialog.this.name.getText().equals("")) {
                    MailToDialog.this.name.setText(MailToDialog.this.mail.getText());
                }
                if (evt.getKeyCode() == 9) {
                    MailToDialog.this.name.requestFocus();
                }
            }
        });
        this.mail.setFont(this.menuFontSize);
        this.mail.addKeyListener(this);
        this.mail.addMouseListener(this);
        pane.add((Component)this.mail, c);
        c.gridy = 1;
        label = new JLabel("  " + this.bundle.getString("EMailAdressInfo") + " ");
        label.setFont(this.menuFontSize);
        pane.add((Component)label, c);
        this.name = new JTextField(labelText, 20);
        this.name.setFont(this.menuFontSize);
        pane.add((Component)this.name, c);
        this.name.addFocusListener(this);
        this.name.addMouseListener(this);
        c.gridx = 3;
        c.gridy = 2;
        this.cancelButton = new JButton(this.bundle.getString("mailToDialogCancelButton"));
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(0, 20, 0, 0);
        this.cancelButton.setFont(this.menuFontSize);
        pane.add((Component)this.cancelButton, c);
        this.insertButton = new JButton(this.bundle.getString("mailToDialogInsertButton"));
        c.gridx = 2;
        c.gridy = 0;
        this.insertButton.setFont(this.menuFontSize);
        pane.add((Component)this.insertButton, c);
        this.insertButton.setNextFocusableComponent(this.cancelButton);
        this.insertButton.addActionListener(this);
        this.insertButton.addKeyListener(this);
        this.insertButton.getRootPane().setDefaultButton(this.insertButton);
        this.insertButton.setDefaultCapable(true);
        this.cancelButton.addActionListener(this);
        this.name.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        TravPolicyMailToDialog policyMailToDialog = new TravPolicyMailToDialog();
        this.setFocusTraversalPolicy(policyMailToDialog);
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.hide();
            this.wiki.getTextWindow().requestFocus();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        Object source = evt.getSource();
        if (arg.equals(this.bundle.getString("mailToDialogInsertButton"))) {
            if (!this.table) {
                this.obsable.input("Insert mailToDialog");
            } else {
                this.obsable.input("Insert mailToDialog in table");
            }
            this.hide();
        }
        if (arg.equals(this.bundle.getString("mailToDialogCancelButton"))) {
            if (!this.table) {
                this.obsable.input("Beende mailToDialog");
            } else {
                this.obsable.input("Beende mailToDialog in table");
            }
            this.hide();
        }
    }

    public void focusGained(FocusEvent arg0) {
        ((JTextField)arg0.getSource()).selectAll();
    }

    public void focusLost(FocusEvent arg0) {
    }

    public boolean getReplace() {
        return this.replace;
    }

    public String getName() {
        try {
            return this.name.getText();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getMail() {
        try {
            return this.mail.getText();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void show() {
        super.show();
        this.setLocationRelativeTo(this.owner);
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    class TravPolicyMailToDialog
    extends FocusTraversalPolicy {
        TravPolicyMailToDialog() {
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return MailToDialog.this.mail;
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return MailToDialog.this.mail;
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return MailToDialog.this.cancelButton;
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent == MailToDialog.this.mail) {
                return MailToDialog.this.name;
            }
            if (aComponent == MailToDialog.this.name) {
                return MailToDialog.this.insertButton;
            }
            if (aComponent == MailToDialog.this.insertButton) {
                return MailToDialog.this.cancelButton;
            }
            if (aComponent == MailToDialog.this.cancelButton) {
                return MailToDialog.this.mail;
            }
            return MailToDialog.this.mail;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent == MailToDialog.this.mail) {
                return MailToDialog.this.cancelButton;
            }
            if (aComponent == MailToDialog.this.cancelButton) {
                return MailToDialog.this.insertButton;
            }
            if (aComponent == MailToDialog.this.insertButton) {
                return MailToDialog.this.name;
            }
            if (aComponent == MailToDialog.this.name) {
                return MailToDialog.this.mail;
            }
            return MailToDialog.this.mail;
        }
    }
}

