/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.wikiwizard.EditorDocument;
import org.wikiwizard.WikiWizardApplet;
import org.wikiwizard.WikiWizardTextPane;

public class PenMouseListener
implements MouseListener {
    private WikiWizardApplet m_applet = null;
    private final MutableAttributeSet normalStyle = new SimpleAttributeSet();
    private int m_startPos = 0;
    private int m_endPos = 0;
    private final String trimRegex = "(\u00e4|\u00f6|\u00fc|\u00df|[a-z]|[A-Z]|[0-9]|_|-|\\.)*";
    private ArrayList m_startPosList = new ArrayList();
    private boolean m_active = false;
    private MutableAttributeSet keyWord;
    public String keyword = null;

    public PenMouseListener(WikiWizardApplet applet) {
        this.m_applet = applet;
        Color col = new Color(255, 255, 255, 0);
        this.normalStyle.addAttribute(StyleConstants.Background, col);
        this.keyWord = new SimpleAttributeSet();
        StyleConstants.setBackground(this.keyWord, new Color(255, 248, 147, 100));
    }

    public ArrayList getStartPosList() {
        return this.m_startPosList;
    }

    public void setActive(boolean active) {
        this.m_active = active;
    }

    public void clearHighlightings(int hstart, int hend, int difference) {
        WikiWizardTextPane textPane = this.m_applet.text;
        EditorDocument doc = this.m_applet.doc;
        this.m_applet.doc.setCharacterAttributes(hstart, hend, this.normalStyle, false);
        for (int i = 0; i < this.m_startPosList.size(); ++i) {
            int itemPos = (Integer)this.m_startPosList.get(i);
            if (itemPos >= this.m_applet.text.getCaretPosition()) {
                itemPos += difference;
            }
            if (itemPos > hstart && itemPos < hstart + hend) {
                this.m_startPosList.remove(i);
                --i;
                continue;
            }
            this.m_startPosList.set(i, new Integer(itemPos));
        }
    }

    public int findBackward(String regex, String textString, int pos) {
        if (pos >= 0) {
            String actualChar = textString.substring(pos, pos + 1);
            while (actualChar.matches(regex) && pos > 0) {
                actualChar = textString.substring(--pos, pos + 1);
            }
        }
        return pos;
    }

    public int findForward(String regex, String textString, int pos) {
        if (pos + 1 <= textString.length()) {
            String actualChar = textString.substring(pos, pos + 1);
            while (actualChar.matches(regex) && pos > -1) {
                if (++pos <= textString.length()) {
                    actualChar = textString.substring(pos, pos + 1);
                    continue;
                }
                pos = -1;
            }
        }
        return pos;
    }

    public void getKeyWord(int pos, String textString) {
        this.m_endPos = this.findForward("(\u00e4|\u00f6|\u00fc|\u00df|[a-z]|[A-Z]|[0-9]|_|-|\\.)*", textString, pos);
        if (this.m_endPos == -1) {
            this.m_endPos = textString.length();
        }
        this.m_startPos = this.findBackward("(\u00e4|\u00f6|\u00fc|\u00df|[a-z]|[A-Z]|[0-9]|_|-|\\.)*", textString, pos);
        if (this.m_startPos != 0 && this.m_startPos != -1) {
            ++this.m_startPos;
        }
        if (this.m_startPos == this.m_endPos) {
            this.m_startPos = -1;
        }
    }

    public void mouseClicked(MouseEvent arg0) {
        if (arg0.getButton() == 1) {
            try {
                WikiWizardTextPane textPane = this.m_applet.text;
                EditorDocument doc = this.m_applet.doc;
                if (this.m_active) {
                    int pos = textPane.getCaretPosition();
                    String textString = textPane.getDocument().getText(0, textPane.getDocument().getLength());
                    this.getKeyWord(pos, textString);
                    if (this.m_startPos > -1 && this.m_endPos > -1 && this.m_startPos < this.m_endPos) {
                        this.keyword = textString.substring(this.m_startPos, this.m_endPos);
                        this.m_applet.doc.highlightSyntax(3);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void searchKeywords(int hstart, int hend, int difference) throws BadLocationException {
        if (this.keyword != null) {
            this.clearHighlightings(hstart, hend, difference);
            String textString = this.m_applet.doc.getText(hstart, hend);
            EditorDocument doc = this.m_applet.doc;
            int foundPos = 0;
            foundPos = textString.indexOf(this.keyword, 0);
            Pattern p = Pattern.compile("(\u00e4|\u00f6|\u00fc|\u00df|[a-z]|[A-Z]|[0-9]|_|-|\\.)*");
            while (doc.getLength() != 0 && foundPos != -1) {
                boolean before = true;
                if (foundPos - 1 >= 0) {
                    Matcher m = p.matcher(textString.substring(foundPos - 1, foundPos));
                    before = m.matches();
                } else {
                    before = false;
                }
                boolean after = true;
                int endFoundPos = foundPos + this.keyword.length();
                if (endFoundPos < textString.length()) {
                    Matcher m = p.matcher(textString.substring(endFoundPos, endFoundPos + 1));
                    after = m.matches();
                } else {
                    after = false;
                }
                if (!before && !after) {
                    this.m_startPosList.add(new Integer(foundPos + hstart));
                    doc.setCharacterAttributes(foundPos + hstart, this.keyword.length(), this.keyWord, false);
                }
                foundPos = textString.indexOf(this.keyword, foundPos + 1);
            }
        } else {
            this.clearHighlightings(0, this.m_applet.doc.getLength() - 1, difference);
        }
        this.m_applet.m_textPaneBorder.repaint();
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }
}

