/*
 * Copyright (C) 2007, 2008, 2009 Patrick Balleux, Nicolas Cardoso De Castro
 * (nicolas_cardoso@users.sourceforge.net), Daniel Žalar (danizmax@gmail.com)
 *
 * This file is part of JSymphonic program.
 *
 * JSymphonic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JSymphonic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JSymphonic. If not, see <http://www.gnu.org/licenses/>.
 *
 *****
 *
 * Playlist.java
 *
 * Created on 9 juin 2009, 14:30:40
 *
 */

package org.naurd.media.jsymphonic.title;

import java.util.ArrayList;
import java.util.List;

/**
 * This class describes a playlist in a device. It has a name and a list of titles.
 *
 * @author skiron
 */
public class Playlist {
/* FIELDS */
    private String name; // The name of the playlist
    private List<Title> titleList; // The list of titles in the playlist
    private int status = Title.ON_DEVICE; // The status of the playlist, as titles: ON DEVICE, TO EXPORT, TO IMPORT,...

/* CONSTRUCTOR */
    /**
     * Create a new playlist from its name. The list of title is then empty.
     *
     * @param playlistName The name of the playlist.
     */
    public Playlist(String playlistName){
        if(playlistName.length() > 60) {playlistName = (String)playlistName.subSequence(0,59);} // Names are limited to 60 chars
        name = playlistName;
        titleList = new ArrayList();
    }

    /**
     * Create a new playlist from its name and a list of titles.
     *
     * @param playlistName The name of the playlist.
     * @param titles The list of titles which should be used.
     */
    public Playlist(String playlistName, List titles){
        if(playlistName.length() > 60) {playlistName = (String)playlistName.subSequence(0,59);} // Names are limited to 60 chars
        name = playlistName;
        titleList = new ArrayList(titles);
    }

/* GET METHODS */
    /**
     * Obtain the name of the list
     *
     * @return The name of the list.
     */
    public String getName(){
        return name;
    }

    /**
     * Obtain the list of titles in the list
     *
     * @return The list of titles in the list.
     */
    public List getTitles(){
        return titleList;
    }

    /**
     * Obtain the status of the playlist.
     *
     * @return The status of the playlist as it is defined for the title, by the constant from the Title class "Title.ON_DEVICE" (ON DEVICE, TO EXPORT, TO IMPORT).
     */
    public int getStatus(){
        return status;
    }

/* METHODS */
    @Override
    public String toString(){
        return getName();
    }
}
