/*
 * Copyright 2021-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.tooling.validator;

import java.util.Objects;

/**
 * Validation message with severity and location.
 */
public class ValidationMessage {

	private final Severity severity;
	private final Location location;
	private final String message;

	ValidationMessage(Severity severity, Location location, String message) {
		this.severity = severity;
		this.location = location;
		this.message = message;
	}

	/**
	 * Get the severity of this validation message.
	 *
	 * @return the severity
	 */
	public Severity getSeverity() {
		return severity;
	}

	/**
	 * Get the location of this validation message.
	 *
	 * @return the location
	 */
	public Location getLocation() {
		return location;
	}

	/**
	 * Get the message of this validation message.
	 *
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		ValidationMessage that = (ValidationMessage) o;
		return severity == that.severity && location.equals(that.location) && message.equals(that.message);
	}

	@Override
	public int hashCode() {
		return Objects.hash(severity, location, message);
	}

	@Override
	public String toString() {
		return String.format("[%s] %s - %s", severity, location, message);
	}
}
