/*
 * Decompiled with CFR 0.152.
 */
package gifwriter;

import gifwriter.GIFEncoderHashitem;
import gifwriter.GIFWriter;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class GIFAnimWriter {
    int iterations;
    int maxwidth;
    int maxheight;
    Vector frames;
    Vector delays;
    boolean colormap_valid = false;
    Hashtable colormap;
    int defaultcolorkey;

    public GIFAnimWriter(int n) {
        this.iterations = n;
        this.colormap = null;
        this.colormap_valid = false;
    }

    public GIFAnimWriter() {
        this(0);
    }

    public void doColorMap(Color color, boolean bl) throws IOException {
        if (this.colormap == null) {
            this.colormap = new Hashtable();
        }
        int n = this.colormap.size();
        int n2 = color.getRGB();
        GIFEncoderHashitem gIFEncoderHashitem = (GIFEncoderHashitem)this.colormap.get(n2);
        if (gIFEncoderHashitem == null) {
            if (n >= 256) {
                throw new IOException("Too many colors for a GIF");
            }
            gIFEncoderHashitem = new GIFEncoderHashitem(n2, color, 1, n);
            ++n;
            this.colormap.put(n2, gIFEncoderHashitem);
        } else {
            ++gIFEncoderHashitem.count;
        }
        if (bl) {
            this.defaultcolorkey = n2;
        }
    }

    public void doColorMap(Image image) throws IOException {
        GIFWriter gIFWriter = new GIFWriter();
        gIFWriter.setImage(image);
        if (!this.colormap_valid) {
            this.maxwidth = gIFWriter.getWidth();
            this.maxheight = gIFWriter.getHeight();
            gIFWriter.loadData();
            gIFWriter.doColorMap();
            this.colormap = gIFWriter.getColorMap();
            this.colormap_valid = true;
        } else {
            int n = gIFWriter.getWidth();
            if (n > this.maxwidth) {
                this.maxwidth = n;
            }
            if ((n = gIFWriter.getHeight()) > this.maxheight) {
                this.maxheight = n;
            }
            gIFWriter.loadData();
            gIFWriter.setColorMap(this.colormap, this.defaultcolorkey);
            gIFWriter.doColorMap();
        }
        gIFWriter.flushPixels();
    }

    public Hashtable getColorMap() {
        return this.colormap;
    }

    public void writeHeader(OutputStream outputStream) throws IOException {
        GIFWriter.writeHeader(this.colormap, this.maxwidth, this.maxheight, outputStream);
        GIFWriter.Putbyte((byte)33, outputStream);
        GIFWriter.Putbyte((byte)-1, outputStream);
        GIFWriter.Putbyte((byte)11, outputStream);
        GIFWriter.Putbyte((byte)78, outputStream);
        GIFWriter.Putbyte((byte)69, outputStream);
        GIFWriter.Putbyte((byte)84, outputStream);
        GIFWriter.Putbyte((byte)83, outputStream);
        GIFWriter.Putbyte((byte)67, outputStream);
        GIFWriter.Putbyte((byte)65, outputStream);
        GIFWriter.Putbyte((byte)80, outputStream);
        GIFWriter.Putbyte((byte)69, outputStream);
        GIFWriter.Putbyte((byte)50, outputStream);
        GIFWriter.Putbyte((byte)46, outputStream);
        GIFWriter.Putbyte((byte)48, outputStream);
        GIFWriter.Putbyte((byte)3, outputStream);
        GIFWriter.Putbyte((byte)1, outputStream);
        GIFWriter.Putword(this.iterations, outputStream);
        GIFWriter.Putbyte((byte)0, outputStream);
    }

    public void writeDelay(int n, OutputStream outputStream) throws IOException {
        GIFWriter.Putbyte((byte)33, outputStream);
        GIFWriter.Putbyte((byte)-7, outputStream);
        GIFWriter.Putbyte((byte)4, outputStream);
        GIFWriter.Putbyte((byte)0, outputStream);
        GIFWriter.Putword(n, outputStream);
        GIFWriter.Putbyte((byte)0, outputStream);
        GIFWriter.Putbyte((byte)0, outputStream);
    }

    public void writeGIF(Image image, OutputStream outputStream) throws IOException {
        GIFWriter gIFWriter = new GIFWriter();
        gIFWriter.setImage(image);
        gIFWriter.loadData();
        gIFWriter.setColorMap(this.colormap, this.defaultcolorkey);
        gIFWriter.writeBody(outputStream);
        gIFWriter.flushPixels();
    }

    public void writeTrailer(OutputStream outputStream) throws IOException {
        GIFWriter.writeTrailer(outputStream);
    }
}

