/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import jugglinglab.core.AnimatorPrefs;
import jugglinglab.core.PatternList;
import jugglinglab.core.PatternListWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.core.PlatformSpecific;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLParser;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.NotationGUI;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ApplicationWindow
extends JFrame
implements ActionListener,
WindowListener {
    static ResourceBundle guistrings = JLLocale.getBundle("GUIStrings");
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    protected NotationGUI ng = new NotationGUI(this);
    protected boolean macos = PlatformSpecific.getPlatformSpecific().isMacOS();
    protected static final String[] fileItems = new String[]{"Open JML...", "Convert JML...", null, "Quit"};
    protected static final String[] fileCommands = new String[]{"open", "convert", null, "exit"};
    protected static final char[] fileShortcuts = new char[]{'O', ' ', ' ', 'Q'};
    public static final int FILE_NONE = 0;
    public static final int FILE_OPEN = 3;
    public static final int FILE_CONVERT = 5;
    public static final int FILE_EXIT = 6;

    public ApplicationWindow(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        super(string);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = this.createFileMenu();
        jMenuBar.add(jMenu);
        JMenu jMenu2 = this.ng.createNotationMenu();
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = this.ng.createHelpMenu(!this.macos);
        if (jMenu3 != null) {
            jMenuBar.add(jMenu3);
        }
        this.setJMenuBar(jMenuBar);
        PlatformSpecific.getPlatformSpecific().registerParent(this);
        PlatformSpecific.getPlatformSpecific().setupPlatform();
        this.setDefaultCloseOperation(0);
        this.ng.setDoubleBuffered(true);
        this.setBackground(new Color(0.9f, 0.9f, 0.9f));
        this.setContentPane(this.ng);
        this.ng.setNotation(1);
        Locale locale = JLLocale.getLocale();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        jMenu2.getItem(0).setSelected(true);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
        this.addWindowListener(this);
    }

    protected JMenu createFileMenu() {
        JMenu jMenu = new JMenu(guistrings.getString("File"));
        for (int i = 0; i < (this.macos ? fileItems.length - 2 : fileItems.length); ++i) {
            if (fileItems[i] == null) {
                jMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(guistrings.getString(fileItems[i].replace(' ', '_')));
            if (fileShortcuts[i] != ' ') {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            jMenuItem.setActionCommand(fileCommands[i]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals("open")) {
                this.doMenuCommand(3);
            } else if (string.equals("convert")) {
                this.doMenuCommand(5);
            } else if (string.equals("exit")) {
                this.doMenuCommand(6);
            }
        }
        catch (Exception exception) {
            ErrorDialog.handleException(exception);
        }
    }

    public void doMenuCommand(int n) throws JuggleExceptionInternal {
        switch (n) {
            case 0: {
                break;
            }
            case 3: {
                FileFilter fileFilter = new FileFilter(){

                    public boolean accept(File file) {
                        StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".");
                        String string = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                        }
                        return string.equals("jml") || file.isDirectory();
                    }

                    public String getDescription() {
                        return "JML Files";
                    }
                };
                try {
                    if (PlatformSpecific.getPlatformSpecific().showOpenDialog(this, fileFilter) != 0 || PlatformSpecific.getPlatformSpecific().getSelectedFile() == null) break;
                    this.showJMLWindow(PlatformSpecific.getPlatformSpecific().getSelectedFile());
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(this, juggleExceptionUser.getMessage());
                }
                break;
            }
            case 5: {
                FileFilter fileFilter = new FileFilter(){

                    public boolean accept(File file) {
                        StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".");
                        String string = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                        }
                        return string.equals("jml") || file.isDirectory();
                    }

                    public String getDescription() {
                        return "JML Files";
                    }
                };
                try {
                    if (PlatformSpecific.getPlatformSpecific().showOpenDialog(this, fileFilter) != 0 || PlatformSpecific.getPlatformSpecific().getSelectedFile() == null) break;
                    this.convertJML(PlatformSpecific.getPlatformSpecific().getSelectedFile());
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(this, juggleExceptionUser.getMessage());
                }
                break;
            }
            case 6: {
                System.exit(0);
            }
        }
    }

    public void showJMLWindow(File file) throws JuggleExceptionUser, JuggleExceptionInternal {
        Window window = null;
        Window window2 = null;
        try {
            try {
                JMLParser jMLParser = new JMLParser();
                jMLParser.parse(new FileReader(file));
                switch (jMLParser.getFileType()) {
                    case 1: {
                        JMLNode jMLNode = jMLParser.getTree();
                        JMLPattern jMLPattern = new JMLPattern(jMLNode);
                        window = new PatternWindow(jMLPattern.getTitle(), jMLPattern, new AnimatorPrefs());
                        break;
                    }
                    case 2: {
                        JMLNode jMLNode = jMLParser.getTree();
                        window2 = new PatternListWindow(jMLNode);
                        PatternList patternList = ((PatternListWindow)window2).getPatternList();
                        break;
                    }
                    default: {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_invalid_JML"));
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_file_not_found") + ": " + fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_IO") + ": " + iOException.getMessage());
            }
            catch (SAXParseException sAXParseException) {
                String string = errorstrings.getString("Error_parsing");
                Object[] objectArray = new Object[]{new Integer(sAXParseException.getLineNumber())};
                throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
            }
            catch (SAXException sAXException) {
                throw new JuggleExceptionUser(sAXException.getMessage());
            }
        }
        catch (JuggleExceptionUser juggleExceptionUser) {
            if (window != null) {
                window.dispose();
            }
            if (window2 != null) {
                window2.dispose();
            }
            throw juggleExceptionUser;
        }
        catch (JuggleExceptionInternal juggleExceptionInternal) {
            if (window != null) {
                window.dispose();
            }
            if (window2 != null) {
                window2.dispose();
            }
            throw juggleExceptionInternal;
        }
    }

    public void convertJML(File file) throws JuggleExceptionUser {
        String string;
        Object object;
        Object object2;
        int n;
        String string2 = null;
        String string3 = null;
        try {
            n = (int)file.length();
            object2 = new FileReader(file);
            object = new char[n];
            ((InputStreamReader)object2).read((char[])object, 0, n);
            string2 = new String((char[])object);
        }
        catch (IOException iOException) {
            String string4 = errorstrings.getString("Error_reading_file");
            Object[] objectArray = new Object[]{file.getName()};
            throw new JuggleExceptionUser(MessageFormat.format(string4, objectArray));
        }
        n = 0;
        object2 = Pattern.compile("<jml[^>]*version[\\s]*=[\\s]*['\"]([^'\"]*)['\"]").matcher(string2);
        if (((Matcher)object2).find()) {
            if (((Matcher)object2).group(1).equals("1.0")) {
                n = 1;
            } else if (((Matcher)object2).group(1).equals("1.2")) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_already_12"));
            }
        } else if ("1.0".equals("1.0")) {
            n = 1;
        }
        object2 = Pattern.compile("<jml[^>]*>").matcher(string2);
        string3 = ((Matcher)object2).replaceAll("<jml version=\"1.2\">");
        object = new StringBuffer();
        object2 = Pattern.compile("<title>(.*?)</title>").matcher(string3);
        while (((Matcher)object2).find()) {
            string = "<title>" + JMLNode.xmlescape(((Matcher)object2).group(1)).trim() + "</title>";
            ((Matcher)object2).appendReplacement((StringBuffer)object, string);
        }
        ((Matcher)object2).appendTail((StringBuffer)object);
        string3 = ((StringBuffer)object).toString();
        object = new StringBuffer();
        object2 = Pattern.compile("display[\\s]*=[\\s]*\"([^\"]*)\"").matcher(string3);
        while (((Matcher)object2).find()) {
            string = "display=\"" + JMLNode.xmlescape(((Matcher)object2).group(1)).trim() + "\"";
            ((Matcher)object2).appendReplacement((StringBuffer)object, string);
        }
        ((Matcher)object2).appendTail((StringBuffer)object);
        string3 = ((StringBuffer)object).toString();
        object = new StringBuffer();
        object2 = Pattern.compile("animprefs[\\s]*=[\\s]*\"([^\"]*)\"").matcher(string3);
        while (((Matcher)object2).find()) {
            string = "animprefs=\"" + JMLNode.xmlescape(((Matcher)object2).group(1)).trim() + "\"";
            ((Matcher)object2).appendReplacement((StringBuffer)object, string);
        }
        ((Matcher)object2).appendTail((StringBuffer)object);
        string3 = ((StringBuffer)object).toString();
        object = new StringBuffer();
        object2 = Pattern.compile("(<line[^>]*notation[\\s]*=[\\s]*\"jml\"[^>]*?)[\\s]+pattern[\\s]*=[\\s]*['\"]([^']*)['\"]([^>]*)/>").matcher(string3);
        while (((Matcher)object2).find()) {
            string = ((Matcher)object2).group(1) + ((Matcher)object2).group(3) + ">" + ((Matcher)object2).group(2) + "</line>";
            ((Matcher)object2).appendReplacement((StringBuffer)object, string);
        }
        ((Matcher)object2).appendTail((StringBuffer)object);
        string3 = ((StringBuffer)object).toString();
        object = new StringBuffer();
        object2 = Pattern.compile("(<line[^>]*?)[\\s]+pattern[\\s]*=[\\s]*['\"]([^']*)['\"]([^>]*notation[\\s]*=[\\s]*\"jml\"[^>]*?)[\\s]*/>").matcher(string3);
        while (((Matcher)object2).find()) {
            string = ((Matcher)object2).group(1) + ((Matcher)object2).group(3) + ">" + ((Matcher)object2).group(2) + "</line>";
            ((Matcher)object2).appendReplacement((StringBuffer)object, string);
        }
        ((Matcher)object2).appendTail((StringBuffer)object);
        string3 = ((StringBuffer)object).toString();
        object = new StringBuffer();
        object2 = Pattern.compile("(<line[^>]*?)[\\s]+pattern[\\s]*=[\\s]*['\"]([^'\"]*)['\"]([^>]*?)[\\s]*/>").matcher(string3);
        while (((Matcher)object2).find()) {
            string = ((Matcher)object2).group(1) + ((Matcher)object2).group(3) + ">\n" + JMLNode.xmlescape(((Matcher)object2).group(2)).trim() + "\n</line>";
            ((Matcher)object2).appendReplacement((StringBuffer)object, string);
        }
        ((Matcher)object2).appendTail((StringBuffer)object);
        string3 = ((StringBuffer)object).toString();
        if (n != 0) {
            object = new StringBuffer();
            object2 = Pattern.compile("(<event[^>]*)[\\s]+([yz])[\\s]*=[\\s]*\"([^\"]*)\"([^>]*)[\\s]+([yz])[\\s]*=[\\s]*\"([^\"]*)\"").matcher(string3);
            while (((Matcher)object2).find()) {
                string = ((Matcher)object2).group(1) + " " + ((Matcher)object2).group(2) + "=\"" + ((Matcher)object2).group(6) + "\"" + ((Matcher)object2).group(4) + " " + ((Matcher)object2).group(5) + "=\"" + ((Matcher)object2).group(3) + "\"";
                ((Matcher)object2).appendReplacement((StringBuffer)object, string);
            }
            ((Matcher)object2).appendTail((StringBuffer)object);
            string3 = ((StringBuffer)object).toString();
        }
        string = file.getName();
        object2 = Pattern.compile("^(.*)(\\.[^\\.]*)$").matcher(string);
        string = ((Matcher)object2).find() ? ((Matcher)object2).group(1) + "_converted" + ((Matcher)object2).group(2) : string + "_converted";
        try {
            File file2 = new File(file.getParent(), string);
            if (file2.exists()) {
                String string5 = errorstrings.getString("Error_already_exists");
                Object[] objectArray = new Object[]{string};
                throw new JuggleExceptionUser(MessageFormat.format(string5, objectArray));
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
            outputStreamWriter.write(string3, 0, string3.length());
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            String string6 = errorstrings.getString("Error_writing_file");
            Object[] objectArray = new Object[]{string};
            throw new JuggleExceptionUser(MessageFormat.format(string6, objectArray));
        }
    }

    public NotationGUI getNotationGUI() {
        return this.ng;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.doMenuCommand(6);
        }
        catch (Exception exception) {
            System.exit(0);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

