/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import jugglinglab.curve.Curve;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.VelocityRef;
import jugglinglab.util.Coordinate;

public class HandLink {
    protected int jugglernum;
    protected int handnum;
    protected JMLEvent startevent;
    protected JMLEvent endevent;
    protected VelocityRef startvelref;
    protected VelocityRef endvelref;
    protected Curve hp;
    protected boolean ismaster;
    protected HandLink[] duplicates;
    protected HandLink master;
    public static final int NO_HAND = 0;
    public static final int LEFT_HAND = 1;
    public static final int RIGHT_HAND = 2;

    public HandLink(int n, int n2, JMLEvent jMLEvent, JMLEvent jMLEvent2) {
        this.jugglernum = n;
        this.handnum = n2;
        this.startevent = jMLEvent;
        this.endevent = jMLEvent2;
        this.hp = null;
        this.ismaster = true;
        this.duplicates = null;
        this.master = null;
    }

    public static int index(int n) {
        return n == 1 ? 0 : 1;
    }

    public int getJuggler() {
        return this.jugglernum;
    }

    public int getHand() {
        return this.handnum;
    }

    public JMLEvent getStartEvent() {
        return this.startevent;
    }

    public JMLEvent getEndEvent() {
        return this.endevent;
    }

    public VelocityRef getStartVelocityRef() {
        return this.startvelref;
    }

    public void setStartVelocityRef(VelocityRef velocityRef) {
        this.startvelref = velocityRef;
    }

    public VelocityRef getEndVelocityRef() {
        return this.endvelref;
    }

    public void setEndVelocityRef(VelocityRef velocityRef) {
        this.endvelref = velocityRef;
    }

    public void setHandCurve(Curve curve) {
        this.hp = curve;
    }

    public Curve getHandCurve() {
        return this.hp;
    }

    public boolean isMaster() {
        return this.ismaster;
    }

    public String toString() {
        Object object;
        String string = null;
        Coordinate coordinate = this.startevent.getGlobalCoordinate();
        string = "Link from (x=" + coordinate.x + ",y=" + coordinate.y + ",z=" + coordinate.z + ",t=" + this.startevent.getT() + ") ";
        Coordinate coordinate2 = this.endevent.getGlobalCoordinate();
        string = string + "to (x=" + coordinate2.x + ",y=" + coordinate2.y + ",z=" + coordinate2.z + ",t=" + this.endevent.getT() + ")";
        VelocityRef velocityRef = this.getStartVelocityRef();
        if (velocityRef != null) {
            object = velocityRef.getVelocity();
            string = string + "\n      start velocity (x=" + ((Coordinate)object).x + ",y=" + ((Coordinate)object).y + ",z=" + ((Coordinate)object).z + ")";
        }
        if ((velocityRef = this.getEndVelocityRef()) != null) {
            object = velocityRef.getVelocity();
            string = string + "\n      end velocity (x=" + ((Coordinate)object).x + ",y=" + ((Coordinate)object).y + ",z=" + ((Coordinate)object).z + ")";
        }
        if ((object = this.getHandCurve()) != null) {
            Coordinate coordinate3 = ((Curve)object).getMax(this.startevent.getT(), this.endevent.getT());
            Coordinate coordinate4 = ((Curve)object).getMin(this.startevent.getT(), this.endevent.getT());
            string = string + "\n      minimum (x=" + coordinate4.x + ",y=" + coordinate4.y + ",z=" + coordinate4.z + ")";
            string = string + "\n      maximum (x=" + coordinate3.x + ",y=" + coordinate3.y + ",z=" + coordinate3.z + ")";
        } else {
            string = string + "\n      no handpath";
        }
        return string;
    }
}

