/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.util.Hashtable;
import java.util.ResourceBundle;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public abstract class Notation {
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    static Hashtable hash = null;
    public static final String[] builtinNotations = new String[]{"Siteswap"};
    public static final int NOTATION_NONE = 0;
    public static final int NOTATION_SITESWAP = 1;

    public static Notation getNotation(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        Notation notation;
        if (hash == null) {
            hash = new Hashtable();
        }
        if ((notation = (Notation)hash.get(string.toLowerCase())) == null) {
            Notation notation2 = null;
            try {
                Object obj = Class.forName("jugglinglab.notation." + string.toLowerCase() + "Notation").newInstance();
                if (!(obj instanceof Notation)) {
                    throw new JuggleExceptionInternal(errorstrings.getString("Error_notation_bad") + ": '" + string + "'");
                }
                notation2 = (Notation)obj;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_notation_notfound") + ": '" + string + "'");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_notation_cantaccess") + ": '" + string + "'");
            }
            catch (InstantiationException instantiationException) {
                throw new JuggleExceptionInternal(errorstrings.getString("Error_notation_cantcreate") + ": '" + string + "'");
            }
            hash.put(string.toLowerCase(), notation2);
            return notation2;
        }
        return notation;
    }

    public abstract String getName();

    public abstract JMLPattern getJMLPattern(String var1) throws JuggleExceptionUser, JuggleExceptionInternal;
}

