/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import jugglinglab.notation.mhnBody;
import jugglinglab.notation.mhnHands;
import jugglinglab.notation.mhnSymmetry;
import jugglinglab.notation.mhnThrow;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;

public class mhnPattern {
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    protected static double bps_default = -1.0;
    protected static double dwell_default = 1.3;
    protected static double gravity_default = 980.0;
    protected static double propdiam_default = 10.0;
    protected static double bouncefrac_default = 0.9;
    protected static String prop_default = "ball";
    protected String pattern;
    protected double bps = bps_default;
    protected double dwell = dwell_default;
    protected double gravity = gravity_default;
    protected double propdiam = propdiam_default;
    protected double bouncefrac = bouncefrac_default;
    protected String prop = prop_default;
    protected String[] color = null;
    protected int numjugglers;
    protected int numpaths;
    protected int period;
    protected int max_occupancy;
    protected mhnThrow[][][][] th;
    protected mhnHands hands = null;
    protected mhnBody bodies = null;
    protected int max_throw;
    protected int indexes;
    protected Vector symmetry = null;
    public static final int RIGHT_HAND = 0;
    public static final int LEFT_HAND = 1;

    protected int getNumberOfJugglers() {
        return this.numjugglers;
    }

    protected int getNumberOfPaths() {
        return this.numpaths;
    }

    protected int getPeriod() {
        return this.period;
    }

    protected int getIndexes() {
        return this.indexes;
    }

    protected int getMaxOccupancy() {
        return this.max_occupancy;
    }

    protected int getMaxThrow() {
        return this.max_throw;
    }

    protected mhnThrow[][][][] getThrows() {
        return this.th;
    }

    protected int getNumberOfSymmetries() {
        return this.symmetry.size();
    }

    protected String getPropName() {
        return this.prop;
    }

    protected void addSymmetry(mhnSymmetry mhnSymmetry2) {
        this.symmetry.addElement(mhnSymmetry2);
    }

    protected mhnSymmetry getSymmetry(int n) {
        return (mhnSymmetry)this.symmetry.elementAt(n);
    }

    public void parseInput(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (string.indexOf(61) == -1) {
            this.pattern = string;
            return;
        }
        ParameterList parameterList = new ParameterList(string);
        String string2 = null;
        this.pattern = parameterList.getParameter("pattern");
        if (this.pattern == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_no_pattern"));
        }
        string2 = parameterList.getParameter("bps");
        if (string2 != null) {
            try {
                this.bps = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_bps_value"));
            }
        }
        if ((string2 = parameterList.getParameter("dwell")) != null) {
            try {
                this.dwell = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_dwell_value"));
            }
        }
        if ((string2 = parameterList.getParameter("hands")) != null) {
            this.hands = new mhnHands(string2);
        }
        if ((string2 = parameterList.getParameter("body")) != null) {
            this.bodies = new mhnBody(string2);
        }
        if ((string2 = parameterList.getParameter("gravity")) != null) {
            try {
                this.gravity = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("propdiam")) != null) {
            try {
                this.propdiam = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("bouncefrac")) != null) {
            try {
                this.bouncefrac = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("prop")) != null) {
            this.prop = string2;
        }
        if ((string2 = parameterList.getParameter("colors")) != null) {
            if (string2.trim().equals("mixed")) {
                string2 = "{red}{green}{blue}{yellow}{cyan}{magenta}{orange}{pink}{gray}{black}";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "}", false);
            StringTokenizer stringTokenizer2 = null;
            String string3 = null;
            int n = stringTokenizer.countTokens();
            this.color = new String[n];
            block14: for (int i = 0; i < n; ++i) {
                string3 = stringTokenizer.nextToken().replace('{', ' ').trim();
                stringTokenizer2 = new StringTokenizer(string3, ",", false);
                switch (stringTokenizer2.countTokens()) {
                    case 1: {
                        this.color[i] = stringTokenizer2.nextToken().trim().toLowerCase();
                        continue block14;
                    }
                    case 3: {
                        this.color[i] = "{" + string3 + "}";
                        continue block14;
                    }
                    default: {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_color_format"));
                    }
                }
            }
        }
    }
}

