/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import jugglinglab.core.VersionSpecific;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class ballProp
extends Prop {
    static String[] colornames = new String[]{"black", "blue", "cyan", "gray", "green", "magenta", "orange", "pink", "red", "white", "yellow"};
    static Color[] colorvals = new Color[]{Color.black, Color.blue, Color.cyan, Color.gray, Color.green, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    protected static final int colornum_def = 8;
    protected static final double diam_def = 10.0;
    protected static final boolean highlight_def = false;
    protected double diam = 10.0;
    protected int colornum = 8;
    protected Color color;
    protected boolean highlight = false;
    protected Image ballimage;
    protected double lastzoom = 0.0;
    protected Dimension size = null;
    protected Dimension center = null;
    protected Dimension grip = null;

    public String getName() {
        return "Ball";
    }

    public Color getEditorColor() {
        return this.color;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[3];
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < colornames.length; ++i) {
            vector.add(colornames[i]);
        }
        parameterDescriptorArray[0] = new ParameterDescriptor("color", 3, vector, colornames[8], colornames[this.colornum]);
        parameterDescriptorArray[1] = new ParameterDescriptor("diam", 2, null, new Double(10.0), new Double(this.diam));
        parameterDescriptorArray[2] = new ParameterDescriptor("highlight", 1, null, new Boolean(false), new Boolean(this.highlight));
        return parameterDescriptorArray;
    }

    protected void init(String string) throws JuggleExceptionUser {
        String string2;
        Object object;
        Object object2;
        this.color = Color.red;
        if (string == null) {
            return;
        }
        ParameterList parameterList = new ParameterList(string);
        String string3 = parameterList.getParameter("color");
        if (string3 != null) {
            object2 = null;
            if (string3.indexOf(44) == -1) {
                for (int i = 0; i < colornames.length; ++i) {
                    if (!colornames[i].equalsIgnoreCase(string3)) continue;
                    object2 = colorvals[i];
                    this.colornum = i;
                    break;
                }
            } else {
                int n;
                String string4 = string3;
                while ((n = string4.indexOf(123)) >= 0) {
                    string4 = string4.substring(0, n) + string4.substring(n + 1, string4.length());
                }
                while ((n = string4.indexOf(125)) >= 0) {
                    string4 = string4.substring(0, n) + string4.substring(n + 1, string4.length());
                }
                object = new StringTokenizer(string4, ",", false);
                if (((StringTokenizer)object).countTokens() == 3) {
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    String string5 = null;
                    try {
                        string5 = ((StringTokenizer)object).nextToken();
                        n2 = Integer.valueOf(string5);
                        string5 = ((StringTokenizer)object).nextToken();
                        n3 = Integer.valueOf(string5);
                        string5 = ((StringTokenizer)object).nextToken();
                        n4 = Integer.valueOf(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string6 = errorstrings.getString("Error_number_format");
                        Object[] objectArray = new Object[]{string5};
                        throw new JuggleExceptionUser(MessageFormat.format(string6, objectArray));
                    }
                    object2 = new Color(n2, n3, n4);
                } else {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_token_count"));
                }
            }
            if (object2 != null) {
                this.color = object2;
            } else {
                String string7 = errorstrings.getString("Error_prop_color");
                Object[] objectArray = new Object[]{string3};
                throw new JuggleExceptionUser(MessageFormat.format(string7, objectArray));
            }
        }
        if ((object2 = parameterList.getParameter("diam")) != null) {
            try {
                Double d = Double.valueOf((String)object2);
                double d2 = d;
                if (!(d2 > 0.0)) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_prop_diameter"));
                }
                this.diam = d2;
            }
            catch (NumberFormatException numberFormatException) {
                String string8 = errorstrings.getString("Error_number_format");
                object = new Object[]{"diam"};
                throw new JuggleExceptionUser(MessageFormat.format(string8, (Object[])object));
            }
        }
        if ((string2 = parameterList.getParameter("highlight")) != null) {
            Boolean bl = Boolean.valueOf(string2);
            this.highlight = bl;
        }
    }

    public Coordinate getMax() {
        return new Coordinate(this.diam / 2.0, 0.0, this.diam / 2.0);
    }

    public Coordinate getMin() {
        return new Coordinate(-this.diam / 2.0, 0.0, -this.diam / 2.0);
    }

    public Image getProp2DImage(Component component, double d, double[] dArray) {
        if (this.ballimage == null || d != this.lastzoom) {
            this.recalc2D(component, d);
        }
        return this.ballimage;
    }

    public Dimension getProp2DSize(Component component, double d) {
        if (this.size == null || d != this.lastzoom) {
            this.recalc2D(component, d);
        }
        return this.size;
    }

    public Dimension getProp2DCenter(Component component, double d) {
        if (this.center == null || d != this.lastzoom) {
            this.recalc2D(component, d);
        }
        return this.center;
    }

    public Dimension getProp2DGrip(Component component, double d) {
        if (this.grip == null || d != this.lastzoom) {
            this.recalc2D(component, d);
        }
        return this.grip;
    }

    protected void recalc2D(Component component, double d) {
        int n = (int)(0.5 + d * this.diam);
        if (n < 1) {
            n = 1;
        }
        int n2 = -n / 2;
        int n3 = -n;
        this.ballimage = VersionSpecific.getVersionSpecific().makeImage(component, n + 1, n + 1);
        Graphics graphics = this.ballimage.getGraphics();
        VersionSpecific.getVersionSpecific().setAntialias(graphics);
        if (this.highlight) {
            int n4;
            float f = (float)n / 1.2f;
            float[] fArray = new float[]{(float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f};
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = fArray[n4] / 2.5f;
            }
            graphics.setColor(new Color(fArray[0], fArray[1], fArray[2]));
            graphics.fillOval(0, 0, n, n);
            n4 = 0;
            while ((float)n4 < f) {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = Math.min(fArray[i] + 1.0f / f, 1.0f);
                }
                graphics.setColor(new Color(fArray[0], fArray[1], fArray[2]));
                graphics.fillOval((int)((double)n4 / 1.1), (int)((double)n4 / 2.5), n - (int)((double)n4 * 1.3), n - (int)((double)n4 * 1.3));
                ++n4;
            }
        } else {
            graphics.setColor(this.color);
            graphics.fillOval(0, 0, n, n);
        }
        this.size = new Dimension(n, n);
        this.center = new Dimension(n / 2, n / 2);
        this.grip = new Dimension(n / 2, n / 2);
        this.lastzoom = d;
    }
}

