/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import jugglinglab.renderer.JLVector;

public class JLMatrix {
    public double m00 = 1.0;
    public double m01 = 0.0;
    public double m02 = 0.0;
    public double m03 = 0.0;
    public double m10 = 0.0;
    public double m11 = 1.0;
    public double m12 = 0.0;
    public double m13 = 0.0;
    public double m20 = 0.0;
    public double m21 = 0.0;
    public double m22 = 1.0;
    public double m23 = 0.0;
    public double m30 = 0.0;
    public double m31 = 0.0;
    public double m32 = 0.0;
    public double m33 = 1.0;

    public JLMatrix() {
    }

    public JLMatrix(JLVector jLVector, JLVector jLVector2, JLVector jLVector3) {
        this.m00 = jLVector.x;
        this.m10 = jLVector.y;
        this.m20 = jLVector.z;
        this.m01 = jLVector2.x;
        this.m11 = jLVector2.y;
        this.m21 = jLVector2.z;
        this.m02 = jLVector3.x;
        this.m12 = jLVector3.y;
        this.m22 = jLVector3.z;
    }

    public static JLMatrix shiftMatrix(double d, double d2, double d3) {
        JLMatrix jLMatrix = new JLMatrix();
        jLMatrix.m03 = d;
        jLMatrix.m13 = d2;
        jLMatrix.m23 = d3;
        return jLMatrix;
    }

    public static JLMatrix scaleMatrix(double d, double d2, double d3) {
        JLMatrix jLMatrix = new JLMatrix();
        jLMatrix.m00 = d;
        jLMatrix.m11 = d2;
        jLMatrix.m22 = d3;
        return jLMatrix;
    }

    public static JLMatrix scaleMatrix(double d) {
        return JLMatrix.scaleMatrix(d, d, d);
    }

    public static JLMatrix rotateMatrix(double d, double d2, double d3) {
        double d4;
        double d5;
        JLMatrix jLMatrix;
        JLMatrix jLMatrix2 = new JLMatrix();
        if (d != 0.0) {
            jLMatrix = new JLMatrix();
            d5 = Math.sin(d);
            jLMatrix.m11 = d4 = Math.cos(d);
            jLMatrix.m12 = d5;
            jLMatrix.m21 = -d5;
            jLMatrix.m22 = d4;
            jLMatrix2.transform(jLMatrix);
        }
        if (d2 != 0.0) {
            jLMatrix = new JLMatrix();
            d5 = Math.sin(d2);
            jLMatrix.m00 = d4 = Math.cos(d2);
            jLMatrix.m02 = d5;
            jLMatrix.m20 = -d5;
            jLMatrix.m22 = d4;
            jLMatrix2.transform(jLMatrix);
        }
        if (d3 != 0.0) {
            jLMatrix = new JLMatrix();
            d5 = Math.sin(d3);
            jLMatrix.m00 = d4 = Math.cos(d3);
            jLMatrix.m01 = d5;
            jLMatrix.m10 = -d5;
            jLMatrix.m11 = d4;
            jLMatrix2.transform(jLMatrix);
        }
        return jLMatrix2;
    }

    public void shift(double d, double d2, double d3) {
        this.transform(JLMatrix.shiftMatrix(d, d2, d3));
    }

    public void scale(double d, double d2, double d3) {
        this.transform(JLMatrix.scaleMatrix(d, d2, d3));
    }

    public void scale(double d) {
        this.transform(JLMatrix.scaleMatrix(d));
    }

    public void rotate(double d, double d2, double d3) {
        this.transform(JLMatrix.rotateMatrix(d, d2, d3));
    }

    public void transform(JLMatrix jLMatrix) {
        JLMatrix jLMatrix2 = this.getClone();
        this.m00 = jLMatrix.m00 * jLMatrix2.m00 + jLMatrix.m01 * jLMatrix2.m10 + jLMatrix.m02 * jLMatrix2.m20;
        this.m01 = jLMatrix.m00 * jLMatrix2.m01 + jLMatrix.m01 * jLMatrix2.m11 + jLMatrix.m02 * jLMatrix2.m21;
        this.m02 = jLMatrix.m00 * jLMatrix2.m02 + jLMatrix.m01 * jLMatrix2.m12 + jLMatrix.m02 * jLMatrix2.m22;
        this.m03 = jLMatrix.m00 * jLMatrix2.m03 + jLMatrix.m01 * jLMatrix2.m13 + jLMatrix.m02 * jLMatrix2.m23 + jLMatrix.m03;
        this.m10 = jLMatrix.m10 * jLMatrix2.m00 + jLMatrix.m11 * jLMatrix2.m10 + jLMatrix.m12 * jLMatrix2.m20;
        this.m11 = jLMatrix.m10 * jLMatrix2.m01 + jLMatrix.m11 * jLMatrix2.m11 + jLMatrix.m12 * jLMatrix2.m21;
        this.m12 = jLMatrix.m10 * jLMatrix2.m02 + jLMatrix.m11 * jLMatrix2.m12 + jLMatrix.m12 * jLMatrix2.m22;
        this.m13 = jLMatrix.m10 * jLMatrix2.m03 + jLMatrix.m11 * jLMatrix2.m13 + jLMatrix.m12 * jLMatrix2.m23 + jLMatrix.m13;
        this.m20 = jLMatrix.m20 * jLMatrix2.m00 + jLMatrix.m21 * jLMatrix2.m10 + jLMatrix.m22 * jLMatrix2.m20;
        this.m21 = jLMatrix.m20 * jLMatrix2.m01 + jLMatrix.m21 * jLMatrix2.m11 + jLMatrix.m22 * jLMatrix2.m21;
        this.m22 = jLMatrix.m20 * jLMatrix2.m02 + jLMatrix.m21 * jLMatrix2.m12 + jLMatrix.m22 * jLMatrix2.m22;
        this.m23 = jLMatrix.m20 * jLMatrix2.m03 + jLMatrix.m21 * jLMatrix2.m13 + jLMatrix.m22 * jLMatrix2.m23 + jLMatrix.m23;
    }

    public JLMatrix getClone() {
        JLMatrix jLMatrix = new JLMatrix();
        jLMatrix.m00 = this.m00;
        jLMatrix.m01 = this.m01;
        jLMatrix.m02 = this.m02;
        jLMatrix.m03 = this.m03;
        jLMatrix.m10 = this.m10;
        jLMatrix.m11 = this.m11;
        jLMatrix.m12 = this.m12;
        jLMatrix.m13 = this.m13;
        jLMatrix.m20 = this.m20;
        jLMatrix.m21 = this.m21;
        jLMatrix.m22 = this.m22;
        jLMatrix.m23 = this.m23;
        jLMatrix.m30 = this.m30;
        jLMatrix.m31 = this.m31;
        jLMatrix.m32 = this.m32;
        jLMatrix.m33 = this.m33;
        return jLMatrix;
    }

    public JLMatrix inverse() {
        JLMatrix jLMatrix = new JLMatrix();
        double d = this.m12;
        double d2 = this.m10 * this.m01;
        double d3 = this.m10 * this.m21;
        double d4 = this.m02;
        double d5 = this.m20 * this.m01;
        double d6 = this.m20 * this.m11;
        double d7 = this.m02 * this.m21;
        double d8 = this.m03 * this.m21;
        double d9 = this.m01 * this.m12;
        double d10 = this.m01 * this.m13;
        double d11 = this.m02 * this.m11;
        double d12 = this.m03 * this.m11;
        double d13 = this.m10 * this.m22;
        double d14 = this.m10 * this.m23;
        double d15 = this.m20 * this.m12;
        double d16 = this.m20 * this.m13;
        double d17 = this.m00 * this.m22;
        double d18 = this.m00 * this.m23;
        double d19 = this.m20 * this.m02;
        double d20 = this.m20 * this.m03;
        double d21 = this.m00 * this.m12;
        double d22 = this.m00 * this.m13;
        double d23 = this.m10 * this.m02;
        double d24 = this.m10 * this.m03;
        double d25 = this.m00 * this.m11;
        double d26 = this.m00 * this.m21;
        double d27 = d25 * this.m22 - d26 * d - d2 * this.m22 + d3 * d4;
        double d28 = d5 * d - d6 * d4;
        double d29 = 1.0 / (d27 + d28);
        jLMatrix.m00 = (this.m11 * this.m22 * this.m33 - this.m11 * this.m23 * this.m32 - this.m21 * this.m12 * this.m33 + this.m21 * this.m13 * this.m32 + this.m31 * this.m12 * this.m23 - this.m31 * this.m13 * this.m22) * d29;
        jLMatrix.m01 = -(this.m01 * this.m22 * this.m33 - this.m01 * this.m23 * this.m32 - d7 * this.m33 + d8 * this.m32) * d29;
        jLMatrix.m02 = (d9 * this.m33 - d10 * this.m32 - d11 * this.m33 + d12 * this.m32) * d29;
        jLMatrix.m03 = -(d9 * this.m23 - d10 * this.m22 - d11 * this.m23 + d12 * this.m22 + d7 * this.m13 - d8 * this.m12) * d29;
        jLMatrix.m10 = -(d13 * this.m33 - d14 * this.m32 - d15 * this.m33 + d16 * this.m32) * d29;
        jLMatrix.m11 = (d17 * this.m33 - d18 * this.m32 - d19 * this.m33 + d20 * this.m32) * d29;
        jLMatrix.m12 = -(d21 * this.m33 - d22 * this.m32 - d23 * this.m33 + d24 * this.m32) * d29;
        jLMatrix.m13 = (d21 * this.m23 - d22 * this.m22 - d23 * this.m23 + d24 * this.m22 + d19 * this.m13 - d20 * this.m12) * d29;
        jLMatrix.m20 = (d3 * this.m33 - d14 * this.m31 - d6 * this.m33 + d16 * this.m31) * d29;
        jLMatrix.m21 = -(d26 * this.m33 - d18 * this.m31 - d5 * this.m33 + d20 * this.m31) * d29;
        jLMatrix.m22 = (d25 * this.m33 - d22 * this.m31 - d2 * this.m33 + d24 * this.m31) * d29;
        jLMatrix.m23 = -(d25 * this.m23 - d22 * this.m21 - d2 * this.m23 + d24 * this.m21 + d5 * this.m13 - d20 * this.m11) * d29;
        return jLMatrix;
    }
}

